/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.remote.BlockingQueueOperationListener;
import org.jboss.as.controller.remote.TransactionalOperationImpl;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public abstract class ServerTaskExecutor {
    private final OperationContext context;
    private final Map<ServerIdentity, ExecutedServerRequest> submittedTasks;
    private final List<ServerPreparedResponse> preparedResults;

    protected ServerTaskExecutor(OperationContext context, Map<ServerIdentity, ExecutedServerRequest> submittedTasks, List<ServerPreparedResponse> preparedResults) {
        this.context = context;
        this.submittedTasks = submittedTasks;
        this.preparedResults = preparedResults;
    }

    protected abstract int execute(TransactionalProtocolClient.TransactionalOperationListener<ServerOperation> var1, ServerIdentity var2, ModelNode var3) throws OperationFailedException;

    public int executeTask(TransactionalProtocolClient.TransactionalOperationListener<ServerOperation> listener, ServerUpdateTask task) {
        try {
            return this.execute(listener, task.getServerIdentity(), task.getOperation());
        }
        catch (OperationFailedException e) {
            ServerIdentity identity = task.getServerIdentity();
            ServerOperation serverOperation = new ServerOperation(identity, task.getOperation(), null, null, OperationResultTransformer.ORIGINAL_RESULT);
            TransactionalProtocolClient.PreparedOperation result = BlockingQueueOperationListener.FailedOperation.create((TransactionalProtocolClient.Operation)serverOperation, (Throwable)e);
            listener.operationPrepared(result);
            this.recordExecutedRequest(new ExecutedServerRequest(identity, (Future<OperationResponse>)result.getFinalResult(), OperationResultTransformer.ORIGINAL_RESULT));
            return 1;
        }
    }

    void cancelTask(ServerIdentity toCancel) {
        ExecutedServerRequest task = this.submittedTasks.get(toCancel);
        if (task != null) {
            task.asyncCancel();
        }
    }

    protected boolean executeOperation(TransactionalProtocolClient.TransactionalOperationListener<ServerOperation> listener, TransactionalProtocolClient client, ServerIdentity identity, ModelNode operation, OperationResultTransformer transformer) {
        if (client == null) {
            return false;
        }
        DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(this.context);
        DelegatingOperationAttachments operationAttachments = new DelegatingOperationAttachments(this.context);
        ServerOperation serverOperation = new ServerOperation(identity, operation, messageHandler, operationAttachments, transformer);
        try {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Sending %s to %s", operation, identity);
            AsyncFuture result = client.execute(listener, (TransactionalProtocolClient.Operation)serverOperation);
            this.recordExecutedRequest(new ExecutedServerRequest(identity, (Future<OperationResponse>)result, transformer));
        }
        catch (IOException e) {
            TransactionalProtocolClient.PreparedOperation result = BlockingQueueOperationListener.FailedOperation.create((TransactionalProtocolClient.Operation)serverOperation, (Throwable)e);
            listener.operationPrepared(result);
            this.recordExecutedRequest(new ExecutedServerRequest(identity, (Future<OperationResponse>)result.getFinalResult(), transformer));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordExecutedRequest(ExecutedServerRequest task) {
        Map<ServerIdentity, ExecutedServerRequest> map = this.submittedTasks;
        synchronized (map) {
            this.submittedTasks.put(task.getIdentity(), task);
        }
    }

    void recordPreparedOperation(TransactionalProtocolClient.PreparedOperation<ServerOperation> preparedOperation) {
        this.recordPreparedTask(new ServerPreparedResponse(preparedOperation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordOperationPrepareTimeout(BlockingQueueOperationListener.FailedOperation<ServerOperation> failedOperation) {
        this.recordPreparedTask(new ServerPreparedResponse((TransactionalProtocolClient.PreparedOperation<ServerOperation>)failedOperation));
        ServerIdentity identity = ((ServerOperation)failedOperation.getOperation()).getIdentity();
        AsyncFuture finalResult = failedOperation.getFinalResult();
        Map<ServerIdentity, ExecutedServerRequest> map = this.submittedTasks;
        synchronized (map) {
            this.submittedTasks.put(identity, new ExecutedServerRequest(identity, (Future<OperationResponse>)finalResult));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordPreparedTask(ServerPreparedResponse task) {
        List<ServerPreparedResponse> list = this.preparedResults;
        synchronized (list) {
            this.preparedResults.add(task);
        }
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public boolean isAutoCloseStreams() {
            return false;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }

        public void close() throws IOException {
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }

    public static class ExecutedServerRequest
    implements OperationResultTransformer {
        private final ServerIdentity identity;
        private final Future<OperationResponse> finalResult;
        private final OperationResultTransformer transformer;

        public ExecutedServerRequest(ServerIdentity identity, Future<OperationResponse> finalResult) {
            this(identity, finalResult, OperationResultTransformer.ORIGINAL_RESULT);
        }

        public ExecutedServerRequest(ServerIdentity identity, Future<OperationResponse> finalResult, OperationResultTransformer transformer) {
            this.identity = identity;
            this.finalResult = finalResult;
            this.transformer = transformer;
        }

        public ServerIdentity getIdentity() {
            return this.identity;
        }

        public Future<OperationResponse> getFinalResult() {
            return this.finalResult;
        }

        public ModelNode transformResult(ModelNode result) {
            return this.transformer.transformResult(result);
        }

        private void asyncCancel() {
            if (this.finalResult instanceof AsyncFuture) {
                ((AsyncFuture)this.finalResult).asyncCancel(true);
            }
        }
    }

    public static class ServerPreparedResponse {
        private TransactionalProtocolClient.PreparedOperation<ServerOperation> preparedOperation;

        ServerPreparedResponse(TransactionalProtocolClient.PreparedOperation<ServerOperation> preparedOperation) {
            this.preparedOperation = preparedOperation;
        }

        public TransactionalProtocolClient.PreparedOperation<ServerOperation> getPreparedOperation() {
            return this.preparedOperation;
        }

        public ServerIdentity getServerIdentity() {
            return ((ServerOperation)this.preparedOperation.getOperation()).getIdentity();
        }

        public String getServerGroupName() {
            return this.getServerIdentity().getServerGroupName();
        }

        public boolean isTimedOut() {
            return this.preparedOperation.isTimedOut();
        }

        public boolean finalizeTransaction(boolean commit) {
            boolean failed = this.preparedOperation.isFailed();
            if (commit && failed) {
                return false;
            }
            if (commit) {
                this.preparedOperation.commit();
            } else if (!failed) {
                this.preparedOperation.rollback();
            }
            return true;
        }
    }

    public static class ServerOperation
    extends TransactionalOperationImpl {
        private final ServerIdentity identity;
        private final OperationResultTransformer transformer;

        ServerOperation(ServerIdentity identity, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments, OperationResultTransformer transformer) {
            super(operation, messageHandler, attachments);
            this.identity = identity;
            this.transformer = transformer;
        }

        public ServerIdentity getIdentity() {
            return this.identity;
        }

        ModelNode transformResult(ModelNode result) {
            return this.transformer.transformResult(result);
        }
    }

    static class ServerOperationListener
    extends BlockingQueueOperationListener<ServerOperation> {
        ServerOperationListener() {
        }

        public void operationPrepared(TransactionalProtocolClient.PreparedOperation<ServerOperation> prepared) {
            super.operationPrepared(prepared);
        }

        public void operationComplete(ServerOperation operation, OperationResponse result) {
            super.operationComplete((TransactionalProtocolClient.Operation)operation, result);
        }

        protected void drainTo(Collection<TransactionalProtocolClient.PreparedOperation<ServerOperation>> preparedOperations) {
            super.drainTo(preparedOperations);
        }
    }
}

