/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;

public class DelegatingServiceContainer
implements ServiceContainer {
    private final ServiceTarget serviceTargetDelegate;
    private final ServiceRegistry serviceRegistryDelegate;

    public DelegatingServiceContainer(ServiceTarget serviceTargetDelegate, ServiceRegistry serviceRegistryDelegate) {
        this.serviceTargetDelegate = serviceTargetDelegate;
        this.serviceRegistryDelegate = serviceRegistryDelegate;
    }

    protected ServiceTarget getServiceTargetDelegate() {
        return this.serviceTargetDelegate;
    }

    protected ServiceRegistry getServiceRegistryDelegate() {
        return this.serviceRegistryDelegate;
    }

    @Override
    public ServiceBuilder<?> addService() {
        return this.getServiceTargetDelegate().addService();
    }

    @Override
    public ServiceContainer addListener(LifecycleListener listener) {
        this.getServiceTargetDelegate().addListener(listener);
        return this;
    }

    @Override
    public ServiceContainer removeListener(LifecycleListener listener) {
        this.getServiceTargetDelegate().removeListener(listener);
        return this;
    }

    @Override
    public ServiceTarget subTarget() {
        return this.getServiceTargetDelegate().subTarget();
    }

    @Override
    public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
        return this.getServiceRegistryDelegate().getRequiredService(serviceName);
    }

    @Override
    public ServiceController<?> getService(ServiceName serviceName) {
        return this.getServiceRegistryDelegate().getService(serviceName);
    }

    @Override
    public List<ServiceName> getServiceNames() {
        return this.getServiceRegistryDelegate().getServiceNames();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdownComplete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpServices() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpServices(PrintStream stream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTerminateListener(ServiceContainer.TerminateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitTermination() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitStability() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitStability(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitStability(Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problem) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitStability(long timeout, TimeUnit unit, Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problem) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ServiceBuilder<?> addService(ServiceName name) {
        return this.getServiceTargetDelegate().addService(name);
    }

    @Override
    @Deprecated
    public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) {
        return this.getServiceTargetDelegate().addService(name, service);
    }

    @Override
    @Deprecated
    public ServiceTarget addMonitor(StabilityMonitor monitor) {
        this.getServiceTargetDelegate().addMonitor(monitor);
        return this;
    }

    @Override
    @Deprecated
    public ServiceTarget removeMonitor(StabilityMonitor monitor) {
        this.getServiceTargetDelegate().removeMonitor(monitor);
        return this;
    }

    @Override
    @Deprecated
    public ServiceContainer addDependency(ServiceName dependency) {
        this.getServiceTargetDelegate().addDependency(dependency);
        return this;
    }
}

