/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.AbstractCounterConfigurationBuilder;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;

public final class ConvertUtil {
    private ConvertUtil() {
    }

    public static CounterConfiguration parsedConfigToConfig(AbstractCounterConfiguration configuration) {
        if (configuration instanceof StrongCounterConfiguration) {
            return ConvertUtil.parsedConfigToConfig((StrongCounterConfiguration)configuration);
        }
        if (configuration instanceof WeakCounterConfiguration) {
            return ConvertUtil.parsedConfigToConfig((WeakCounterConfiguration)configuration);
        }
        throw new IllegalStateException("[should never happen] unknown CounterConfiguration class: " + String.valueOf(configuration.getClass()));
    }

    public static AbstractCounterConfiguration configToParsedConfig(String name, CounterConfiguration configuration) {
        switch (configuration.type()) {
            case WEAK: {
                WeakCounterConfigurationBuilder wBuilder = new WeakCounterConfigurationBuilder(null);
                wBuilder.concurrencyLevel(configuration.concurrencyLevel());
                ConvertUtil.populateCommonAttributes(wBuilder, name, configuration);
                return wBuilder.create();
            }
            case BOUNDED_STRONG: {
                StrongCounterConfigurationBuilder bBuilder = new StrongCounterConfigurationBuilder(null);
                bBuilder.upperBound(configuration.upperBound());
                bBuilder.lowerBound(configuration.lowerBound());
                bBuilder.lifespan(configuration.lifespan());
                ConvertUtil.populateCommonAttributes(bBuilder, name, configuration);
                return bBuilder.create();
            }
            case UNBOUNDED_STRONG: {
                StrongCounterConfigurationBuilder uBuilder = new StrongCounterConfigurationBuilder(null);
                uBuilder.lifespan(configuration.lifespan());
                ConvertUtil.populateCommonAttributes(uBuilder, name, configuration);
                return uBuilder.create();
            }
        }
        throw new IllegalStateException("[should never happen] unknown CounterConfiguration class: " + String.valueOf(configuration.getClass()));
    }

    private static void populateCommonAttributes(AbstractCounterConfigurationBuilder<?, ?> builder, String name, CounterConfiguration config) {
        builder.name(name);
        builder.initialValue(config.initialValue());
        builder.storage(config.storage());
    }

    private static CounterConfiguration parsedConfigToConfig(StrongCounterConfiguration configuration) {
        return configuration.isBound() ? CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(configuration.initialValue()).lowerBound(configuration.lowerBound()).upperBound(configuration.upperBound()).lifespan(configuration.lifespan()).storage(configuration.storage()).build() : CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(configuration.initialValue()).lifespan(configuration.lifespan()).storage(configuration.storage()).build();
    }

    private static CounterConfiguration parsedConfigToConfig(WeakCounterConfiguration configuration) {
        return CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(configuration.initialValue()).storage(configuration.storage()).concurrencyLevel(configuration.concurrencyLevel()).build();
    }
}

