/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.bean.BeanRetrieval;
import org.hibernate.search.util.common.impl.Contracts;

class TypeBeanReference<T>
implements BeanReference<T> {
    final Class<T> type;
    final BeanRetrieval retrieval;

    TypeBeanReference(Class<T> type, BeanRetrieval retrieval) {
        this.retrieval = retrieval;
        Contracts.assertNotNull(type, (String)"type");
        this.type = type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + this.type + ", retrieval=" + this.retrieval + "]";
    }

    @Override
    public BeanHolder<T> resolve(BeanResolver beanResolver) {
        return beanResolver.resolve(this.type, this.retrieval);
    }

    @Override
    public <U> BeanReference<? extends U> asSubTypeOf(Class<U> expectedType) {
        if (expectedType.isAssignableFrom(this.type)) {
            return this;
        }
        return BeanReference.super.asSubTypeOf(expectedType);
    }
}

