/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingAssociationInverseSideResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.spi.PojoImplicitReindexingResolverSessionContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.DocumentRouter;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.NoOpDocumentRouter;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.route.DocumentRouteDescriptor;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanImpl;
import org.hibernate.search.mapper.pojo.work.impl.PojoLoadingPlanProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractPojoTypeIndexingPlan<I, E, S extends AbstractEntityState>
implements PojoImplicitReindexingAssociationInverseSideResolverRootContext,
PojoTypeIndexingPlan {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    final PojoWorkSessionContext sessionContext;
    final PojoIndexingPlanImpl root;
    final PojoTypeIndexingPlanDelegate<I, E> delegate;
    final Map<I, S> statesPerId = new LinkedHashMap<I, S>();
    private boolean mayRequireLoading = false;

    AbstractPojoTypeIndexingPlan(PojoWorkSessionContext sessionContext, PojoIndexingPlanImpl root, PojoTypeIndexingPlanDelegate<I, E> delegate) {
        this.sessionContext = sessionContext;
        this.root = root;
        this.delegate = delegate;
    }

    @Override
    public void add(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        if (!this.mayRequireLoading && entity == null) {
            this.mayRequireLoading = true;
        }
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        S state = this.getState(identifier);
        ((AbstractEntityState)state).add(entitySupplier);
        ((AbstractEntityState)state).providedRoutes(providedRoutes);
    }

    @Override
    public void addOrUpdate(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths) {
        if (!this.mayRequireLoading && entity == null) {
            this.mayRequireLoading = true;
        }
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        S state = this.getState(identifier);
        ((AbstractEntityState)state).addOrUpdate(entitySupplier, dirtyPaths, forceSelfDirty, forceContainingDirty);
        ((AbstractEntityState)state).providedRoutes(providedRoutes);
    }

    @Override
    public void delete(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        S state = this.getState(identifier);
        ((AbstractEntityState)state).delete(entitySupplier);
        ((AbstractEntityState)state).providedRoutes(providedRoutes);
    }

    @Override
    public void addOrUpdateOrDelete(Object providedId, DocumentRoutesDescriptor providedRoutes, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths) {
        if (!this.mayRequireLoading) {
            this.mayRequireLoading = true;
        }
        I identifier = this.toIdentifier(providedId, null);
        S state = this.getState(identifier);
        ((AbstractEntityState)state).addOrUpdateOrDelete(dirtyPaths, forceSelfDirty, forceContainingDirty);
        ((AbstractEntityState)state).providedRoutes(providedRoutes);
    }

    @Override
    public void updateAssociationInverseSide(BitSet dirtyAssociationPaths, Object[] oldState, Object[] newState) {
        this.typeContext().reindexingResolver().associationInverseSideResolver().resolveEntitiesToReindex(this.root, dirtyAssociationPaths, oldState, newState, this);
    }

    void updateBecauseOfContained(Object entity) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext().identifierMapping().getIdentifier(null, entitySupplier);
        ((AbstractEntityState)this.getState(identifier)).updateBecauseOfContained(entitySupplier);
    }

    void updateBecauseOfContainedAssociation(Object entity, int dirtyAssociationPathOrdinal) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext().identifierMapping().getIdentifier(null, entitySupplier);
        BitSet dirtyPaths = this.typeContext().reindexingResolver().dirtySelfOrContainingFilter().filter(dirtyAssociationPathOrdinal);
        if (dirtyPaths != null) {
            ((AbstractEntityState)this.getState(identifier)).addOrUpdate(entitySupplier, dirtyPaths, false, false);
        }
    }

    void planLoading() {
        for (AbstractEntityState state : this.statesPerId.values()) {
            state.planLoading();
        }
    }

    void resolveDirty(boolean deleteOnly) {
        for (AbstractEntityState state : this.statesPerId.values()) {
            state.resolveDirty(deleteOnly);
        }
    }

    void discard() {
        this.delegate.discard();
    }

    void clearStates() {
        this.mayRequireLoading = false;
        this.statesPerId.clear();
    }

    void process(PojoLoadingPlanProvider loadingPlanProvider) {
        if (this.delegate == null) {
            return;
        }
        if (this.sessionContext.configuredIndexingPlanFilter().isIncluded(this.typeContext().typeIdentifier())) {
            for (AbstractEntityState state : this.statesPerId.values()) {
                state.sendCommandsToDelegate(loadingPlanProvider);
            }
        }
    }

    CompletableFuture<MultiEntityOperationExecutionReport> executeAndReport(OperationSubmitter operationSubmitter) {
        return this.delegate.executeAndReport(operationSubmitter);
    }

    abstract PojoWorkTypeContext<I, E> typeContext();

    abstract DocumentRouter<? super E> router();

    I toIdentifier(Object providedId, Supplier<E> entitySupplier) {
        return this.typeContext().identifierMapping().getIdentifier(providedId, entitySupplier);
    }

    final S getState(I identifier) {
        AbstractEntityState state = (AbstractEntityState)this.statesPerId.get(identifier);
        if (state == null) {
            state = this.createState(identifier);
            this.statesPerId.put(identifier, state);
        }
        return (S)state;
    }

    @Override
    public PojoRuntimeIntrospector runtimeIntrospector() {
        return this.sessionContext.runtimeIntrospector();
    }

    @Override
    public PojoRawTypeIdentifier<?> detectContainingEntityType(Object containingEntity) {
        PojoRawTypeIdentifier<Object> typeIdentifier = this.runtimeIntrospector().detectEntityType(containingEntity);
        if (typeIdentifier == null) {
            throw new AssertionFailure("Attempted to detect entity type of object " + containingEntity + " because a contained entity was modified, but this object does not seem to be an entity.");
        }
        return typeIdentifier;
    }

    @Override
    public void propagateOrIgnoreContainerExtractionException(RuntimeException exception) {
        if (this.isIgnorableDataAccessThrowable(exception)) {
            return;
        }
        throw exception;
    }

    @Override
    public void propagateOrIgnorePropertyAccessException(RuntimeException exception) {
        if (this.isIgnorableDataAccessThrowable(exception)) {
            return;
        }
        throw exception;
    }

    private boolean isIgnorableDataAccessThrowable(RuntimeException exception) {
        Throwable firstNonSearchThrowable = exception;
        while (firstNonSearchThrowable instanceof SearchException) {
            firstNonSearchThrowable = exception.getCause();
        }
        return firstNonSearchThrowable != null && this.sessionContext.runtimeIntrospector().isIgnorableDataAccessThrowable(firstNonSearchThrowable);
    }

    protected abstract S createState(I var1);

    boolean isDeleted(Object unproxiedObject) {
        E entity = this.typeContext().toEntity(unproxiedObject);
        I identifier = this.typeContext().identifierMapping().getIdentifierOrNull(entity);
        AbstractEntityState state = (AbstractEntityState)this.statesPerId.get(identifier);
        if (state == null) {
            return false;
        }
        return state.currentStatus == EntityStatus.ABSENT;
    }

    abstract class AbstractEntityState
    implements PojoImplicitReindexingResolverRootContext {
        final I identifier;
        private Supplier<E> entitySupplier;
        private Integer loadingOrdinal;
        EntityStatus initialStatus = EntityStatus.UNKNOWN;
        EntityStatus currentStatus = EntityStatus.UNKNOWN;
        private boolean updatedBecauseOfContained;
        private boolean forceSelfDirty;
        private boolean forceContainingDirty;
        private BitSet dirtyPaths;

        AbstractEntityState(I identifier) {
            this.identifier = identifier;
        }

        @Override
        public PojoImplicitReindexingResolverSessionContext sessionContext() {
            return AbstractPojoTypeIndexingPlan.this.sessionContext;
        }

        public boolean isDirtyForAddOrUpdate() {
            return AbstractPojoTypeIndexingPlan.this.delegate.isDirtyForAddOrUpdate(this.forceSelfDirty, this.forceContainingDirty, this.dirtyPaths);
        }

        @Override
        public boolean isDirtyForReindexingResolution(PojoPathFilter filter) {
            return this.forceContainingDirty || this.dirtyPaths != null && filter.test(this.dirtyPaths);
        }

        @Override
        public PojoRawTypeIdentifier<?> detectContainingEntityType(Object containingEntity) {
            return AbstractPojoTypeIndexingPlan.this.detectContainingEntityType(containingEntity);
        }

        @Override
        public void propagateOrIgnoreContainerExtractionException(RuntimeException exception) {
            AbstractPojoTypeIndexingPlan.this.propagateOrIgnoreContainerExtractionException(exception);
        }

        @Override
        public void propagateOrIgnorePropertyAccessException(RuntimeException exception) {
            AbstractPojoTypeIndexingPlan.this.propagateOrIgnorePropertyAccessException(exception);
        }

        void add(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (EntityStatus.UNKNOWN.equals((Object)this.initialStatus)) {
                this.initialStatus = EntityStatus.ABSENT;
            }
            this.currentStatus = EntityStatus.PRESENT;
            this.forceSelfDirty = true;
            this.forceContainingDirty = true;
            this.dirtyPaths = null;
        }

        void addOrUpdate(Supplier<E> entitySupplier, BitSet dirtyPaths, boolean forceSelfDirty, boolean forceContainingDirty) {
            this.doAddOrUpdate(entitySupplier);
            this.doUpdateDirty(dirtyPaths, forceSelfDirty, forceContainingDirty);
        }

        void updateBecauseOfContained(Supplier<E> entitySupplier) {
            if (this.currentStatus == EntityStatus.ABSENT) {
                return;
            }
            this.doAddOrUpdate(entitySupplier);
            this.updatedBecauseOfContained = true;
        }

        void doAddOrUpdate(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            this.currentStatus = EntityStatus.PRESENT;
        }

        void delete(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (EntityStatus.UNKNOWN.equals((Object)this.initialStatus)) {
                this.initialStatus = EntityStatus.PRESENT;
            }
            this.currentStatus = EntityStatus.ABSENT;
            this.updatedBecauseOfContained = false;
            this.forceSelfDirty = false;
            this.forceContainingDirty = true;
            this.dirtyPaths = null;
        }

        void addOrUpdateOrDelete(BitSet dirtyPaths, boolean forceSelfDirty, boolean forceContainingDirty) {
            this.entitySupplier = null;
            this.currentStatus = EntityStatus.UNKNOWN;
            this.doUpdateDirty(dirtyPaths, forceSelfDirty, forceContainingDirty);
        }

        protected void doUpdateDirty(BitSet dirtyPaths, boolean forceSelfDirty, boolean forceContainingDirty) {
            this.forceSelfDirty = this.forceSelfDirty || forceSelfDirty;
            this.forceContainingDirty = this.forceContainingDirty || forceContainingDirty;
            this.addDirtyPaths(dirtyPaths);
        }

        abstract void providedRoutes(DocumentRoutesDescriptor var1);

        abstract DocumentRoutesDescriptor providedRoutes();

        void planLoading() {
            if (EntityStatus.ABSENT != this.currentStatus && this.entitySupplier == null) {
                this.loadingOrdinal = AbstractPojoTypeIndexingPlan.this.root.loadingPlan().planLoading(AbstractPojoTypeIndexingPlan.this.typeContext(), this.identifier);
            }
        }

        void resolveDirty(boolean deleteOnly) {
            if (deleteOnly && (this.initialStatus != EntityStatus.PRESENT || this.currentStatus != EntityStatus.ABSENT)) {
                return;
            }
            Supplier entitySupplier = this.entitySupplierOrLoad(AbstractPojoTypeIndexingPlan.this.root);
            if (entitySupplier == null) {
                return;
            }
            try {
                AbstractPojoTypeIndexingPlan.this.typeContext().reindexingResolver().resolveEntitiesToReindex(AbstractPojoTypeIndexingPlan.this.root, entitySupplier.get(), this);
            }
            catch (RuntimeException e) {
                EntityReference entityReference = AbstractPojoTypeIndexingPlan.this.sessionContext.mappingContext().entityReferenceFactoryDelegate().create(AbstractPojoTypeIndexingPlan.this.typeContext().typeIdentifier(), AbstractPojoTypeIndexingPlan.this.typeContext().entityName(), this.identifier);
                throw log.errorResolvingEntitiesToReindex(entityReference, e.getMessage(), e);
            }
            AbstractPojoTypeIndexingPlan.this.typeContext().resolveEntitiesToReindex(AbstractPojoTypeIndexingPlan.this.root, AbstractPojoTypeIndexingPlan.this.sessionContext, this.identifier, entitySupplier, this);
        }

        void sendCommandsToDelegate(PojoLoadingPlanProvider loadingPlanProvider) {
            if (EntityStatus.UNKNOWN.equals((Object)this.currentStatus)) {
                Supplier entitySupplier = this.entitySupplierOrLoad(loadingPlanProvider);
                this.currentStatus = entitySupplier != null ? EntityStatus.PRESENT : EntityStatus.ABSENT;
            }
            switch (this.currentStatus) {
                case PRESENT: {
                    switch (this.initialStatus) {
                        case ABSENT: {
                            this.delegateAdd(loadingPlanProvider);
                            return;
                        }
                        case PRESENT: 
                        case UNKNOWN: {
                            this.delegateAddOrUpdate(loadingPlanProvider);
                            return;
                        }
                    }
                    break;
                }
                case ABSENT: {
                    switch (this.initialStatus) {
                        case ABSENT: {
                            return;
                        }
                        case PRESENT: 
                        case UNKNOWN: {
                            this.delegateDelete();
                            return;
                        }
                    }
                }
            }
        }

        void delegateAdd(PojoLoadingPlanProvider loadingPlanProvider) {
            Supplier entitySupplier = this.entitySupplierOrLoad(loadingPlanProvider);
            if (entitySupplier == null) {
                return;
            }
            DocumentRouteDescriptor currentRoute = AbstractPojoTypeIndexingPlan.this.router().currentRoute(this.identifier, entitySupplier, this.providedRoutes(), AbstractPojoTypeIndexingPlan.this.sessionContext);
            if (currentRoute == null) {
                return;
            }
            AbstractPojoTypeIndexingPlan.this.delegate.add(this.identifier, currentRoute, entitySupplier);
        }

        void delegateAddOrUpdate(PojoLoadingPlanProvider loadingPlanProvider) {
            boolean updateBecauseOfDirty = this.isDirtyForAddOrUpdate();
            if (!this.updatedBecauseOfContained && !updateBecauseOfDirty) {
                return;
            }
            Supplier entitySupplier = this.entitySupplierOrLoad(loadingPlanProvider);
            if (entitySupplier == null) {
                return;
            }
            DocumentRoutesDescriptor routes = AbstractPojoTypeIndexingPlan.this.router().routes(this.identifier, entitySupplier, this.providedRoutes(), AbstractPojoTypeIndexingPlan.this.sessionContext);
            if (routes.currentRoute() == null && routes.previousRoutes().isEmpty()) {
                return;
            }
            AbstractPojoTypeIndexingPlan.this.delegate.addOrUpdate(this.identifier, routes, entitySupplier, this.forceSelfDirty, this.forceContainingDirty, this.dirtyPaths, this.updatedBecauseOfContained, updateBecauseOfDirty);
        }

        void delegateDelete() {
            Supplier entitySupplier = this.entitySupplierNoLoad();
            DocumentRouter<Object> router = entitySupplier != null ? AbstractPojoTypeIndexingPlan.this.router() : NoOpDocumentRouter.INSTANCE;
            DocumentRoutesDescriptor routes = router.routes(this.identifier, entitySupplier, this.providedRoutes(), AbstractPojoTypeIndexingPlan.this.sessionContext);
            if (routes.currentRoute() == null && routes.previousRoutes().isEmpty()) {
                return;
            }
            AbstractPojoTypeIndexingPlan.this.delegate.delete(this.identifier, routes, entitySupplier);
        }

        Supplier<E> entitySupplierNoLoad() {
            return this.entitySupplier;
        }

        Supplier<E> entitySupplierOrLoad(PojoLoadingPlanProvider loadingPlanProvider) {
            if (this.entitySupplier == null && this.loadingOrdinal != null) {
                Object loaded = loadingPlanProvider.loadingPlan().retrieve(AbstractPojoTypeIndexingPlan.this.typeContext(), this.loadingOrdinal);
                this.entitySupplier = AbstractPojoTypeIndexingPlan.this.typeContext().toEntitySupplier(AbstractPojoTypeIndexingPlan.this.sessionContext, loaded);
                this.loadingOrdinal = null;
            }
            return this.entitySupplier;
        }

        private void addDirtyPaths(BitSet newDirtyPaths) {
            if (newDirtyPaths == null) {
                return;
            }
            if (this.dirtyPaths == null) {
                this.dirtyPaths = new BitSet();
            }
            this.dirtyPaths.or(newDirtyPaths);
        }
    }

    protected static enum EntityStatus {
        UNKNOWN,
        PRESENT,
        ABSENT;

    }
}

