/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.StreamSupport;
import org.wildfly.security.auth.server._private.ElytronMessages;
import org.wildfly.security.authz.Roles;

class RegexRoles
implements Roles {
    private final Roles delegate;
    private final Pattern pattern;
    private final String replace;
    private final boolean keepNonMapped;
    private final boolean replaceAll;

    RegexRoles(Roles delegate, Pattern pattern, String replace, boolean keepNonMapped, boolean replaceAll) {
        this.delegate = delegate;
        this.pattern = pattern;
        this.replace = replace;
        this.keepNonMapped = keepNonMapped;
        this.replaceAll = replaceAll;
    }

    @Override
    public boolean contains(String roleName) {
        try {
            return StreamSupport.stream(this.delegate.spliterator(), false).anyMatch(role -> {
                String pattern = this.pattern.pattern();
                boolean containsRegex = this.pattern.matcher((CharSequence)role).find();
                boolean containsRegexAndRoleExists = containsRegex && (this.replaceAll ? role.replaceAll(pattern, this.replace).equals(roleName) : role.replaceFirst(pattern, this.replace).equals(roleName));
                boolean doesNotContainRegexButRoleExists = !containsRegex && this.keepNonMapped && role.equals(roleName);
                return containsRegexAndRoleExists || doesNotContainRegexButRoleExists;
            });
        }
        catch (IndexOutOfBoundsException | PatternSyntaxException ex) {
            throw ElytronMessages.log.invalidReplacementInRegexRoleMapper();
        }
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator iterator = this.delegate.iterator();
        return new Iterator<String>(){
            String next = null;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    String nextt = (String)iterator.next();
                    if (RegexRoles.this.pattern.matcher(nextt).find()) {
                        this.next = RegexRoles.this.replaceAll ? nextt.replaceAll(RegexRoles.this.pattern.pattern(), RegexRoles.this.replace) : nextt.replaceFirst(RegexRoles.this.pattern.pattern(), RegexRoles.this.replace);
                        return true;
                    }
                    if (!RegexRoles.this.keepNonMapped) continue;
                    this.next = nextt;
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String next = this.next;
                this.next = null;
                return next;
            }
        };
    }
}

