/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra.inflow;

import jakarta.jms.Queue;
import jakarta.jms.Topic;
import jakarta.resource.spi.InvalidPropertyException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;

public final class ActiveMQActivationValidationUtils {
    private ActiveMQActivationValidationUtils() {
    }

    public static int validateAcknowledgeMode(String value) {
        if ("DUPS_OK_ACKNOWLEDGE".equalsIgnoreCase(value) || "Dups-ok-acknowledge".equalsIgnoreCase(value)) {
            return 3;
        }
        if ("AUTO_ACKNOWLEDGE".equalsIgnoreCase(value) || "Auto-acknowledge".equalsIgnoreCase(value)) {
            return 1;
        }
        throw new IllegalArgumentException(value);
    }

    public static void validate(String destination, String destinationType, Boolean subscriptionDurability, String subscriptionName) throws InvalidPropertyException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<PropertyDescriptor> propsNotSet = new ArrayList<PropertyDescriptor>();
        try {
            if (destination == null || destination.trim().equals("")) {
                propsNotSet.add(new PropertyDescriptor("destination", ActiveMQActivationSpec.class));
                errorMessages.add("Destination is mandatory.");
            }
            if (destinationType != null && !Topic.class.getName().equals(destinationType) && !Queue.class.getName().equals(destinationType)) {
                propsNotSet.add(new PropertyDescriptor("destinationType", ActiveMQActivationSpec.class));
                errorMessages.add("If set, the destinationType must be either 'jakarta.jms.Topic' or 'jakarta.jms.Queue'.");
            }
            if ((destinationType == null || destinationType.length() == 0 || Topic.class.getName().equals(destinationType)) && subscriptionDurability.booleanValue() && (subscriptionName == null || subscriptionName.length() == 0)) {
                propsNotSet.add(new PropertyDescriptor("subscriptionName", ActiveMQActivationSpec.class));
                errorMessages.add("If subscription is durable then subscription name must be specified.");
            }
        }
        catch (IntrospectionException e) {
            ActiveMQRALogger.LOGGER.unableToValidateProperties(e);
        }
        ActiveMQActivationValidationUtils.buildAndThrowExceptionIfNeeded(propsNotSet, errorMessages);
    }

    private static void buildAndThrowExceptionIfNeeded(List<PropertyDescriptor> propsNotSet, List<String> errorMessages) throws InvalidPropertyException {
        if (propsNotSet.size() > 0) {
            StringBuffer b = new StringBuffer();
            b.append("Invalid settings:");
            for (String errorMessage : errorMessages) {
                b.append(" ");
                b.append(errorMessage);
            }
            InvalidPropertyException e = new InvalidPropertyException(b.toString());
            PropertyDescriptor[] descriptors = propsNotSet.toArray(new PropertyDescriptor[propsNotSet.size()]);
            e.setInvalidPropertyDescriptors(descriptors);
            throw e;
        }
    }
}

