/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl;

import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.lowlevel.comparator.impl.DoubleValuesSourceComparator;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.GeoPointDistanceMultiValuesToSingleValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.engine.spatial.GeoPoint;

public class LuceneGeoPointDistanceComparatorSource
extends LuceneFieldComparatorSource {
    private final GeoPoint center;
    private final double missingValue;
    private final MultiValueMode mode;

    public LuceneGeoPointDistanceComparatorSource(String nestedDocumentPath, GeoPoint center, double missingValue, MultiValueMode mode, Query filter) {
        super(nestedDocumentPath, filter);
        this.center = center;
        this.missingValue = missingValue;
        this.mode = mode;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, boolean enableSkipping, boolean reversed) {
        GeoPointDistanceMultiValuesToSingleValuesSource source = new GeoPointDistanceMultiValuesToSingleValuesSource(fieldname, this.mode, this.nestedDocsProvider, this.center);
        return new DoubleValuesSourceComparator(numHits, fieldname, this.missingValue, reversed, false, source);
    }
}

