/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.domain.model;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.RecordList;
import com.arjuna.ats.arjuna.coordinator.RecordListIterator;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import io.narayana.lra.Current;
import io.narayana.lra.LRAData;
import io.narayana.lra.coordinator.domain.model.LRAChildAbstractRecord;
import io.narayana.lra.coordinator.domain.model.LRAParentAbstractRecord;
import io.narayana.lra.coordinator.domain.model.LRAParticipantRecord;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.logging.LRALogger;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.microprofile.lra.annotation.LRAStatus;

public class LongRunningAction
extends BasicAction {
    private static final String LRA_TYPE = "/StateManager/BasicAction/LongRunningAction";
    private static final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(10);
    private URI id;
    private URI parentId;
    private String clientId;
    private List<LRAParticipantRecord> pending;
    private LRAStatus status;
    private LocalDateTime startTime;
    private LocalDateTime finishTime;
    private ScheduledFuture<?> scheduledAbort;
    private final LRAService lraService;
    LRAParentAbstractRecord par;

    public LongRunningAction(LRAService lraService, String baseUrl, LongRunningAction parent, String clientId) throws URISyntaxException {
        super(new Uid());
        if (lraService == null) {
            throw new Error(LRALogger.i18nLogger.error_invalidArgument("null LRAService"));
        }
        this.lraService = lraService;
        if (parent != null) {
            this.id = Current.buildFullLRAUrl((String)String.format("%s/%s", baseUrl, this.get_uid().fileStringForm()), (URI)parent.getId());
            this.parentId = parent.getId();
        } else {
            this.id = new URI(String.format("%s/%s", baseUrl, this.get_uid().fileStringForm()));
        }
        this.clientId = clientId;
        this.finishTime = null;
        this.status = LRAStatus.Active;
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("created");
        }
    }

    public LongRunningAction(LRAService lraService, Uid rcvUid) {
        super(rcvUid);
        if (lraService == null) {
            throw new Error(LRALogger.i18nLogger.error_invalidArgument("null LRAService"));
        }
        this.lraService = lraService;
        this.id = null;
        this.parentId = null;
        this.clientId = null;
        this.finishTime = null;
        this.status = LRAStatus.Active;
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("created");
        }
    }

    public LongRunningAction(Uid rcvUid) {
        this(new LRAService(), rcvUid);
    }

    public LRAData getLRAData() {
        return new LRAData(this.id, this.clientId, this.status, this.isTopLevel(), this.isRecovering(), this.startTime.toInstant(ZoneOffset.UTC).toEpochMilli(), this.finishTime == null ? 0L : this.finishTime.toInstant(ZoneOffset.UTC).toEpochMilli(), this.getHttpStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save_state(OutputObjectState os, int ot) {
        if (!super.save_state(os, ot) || !this.save_list(os, ot, this.pendingList)) {
            return false;
        }
        try {
            os.packString(this.id == null ? null : this.id.toString());
            os.packString(this.parentId == null ? null : this.parentId.toString());
            os.packString(this.clientId);
            if (this.startTime == null) {
                os.packBoolean(false);
            } else {
                os.packBoolean(true);
                os.packLong(this.startTime.toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            if (this.finishTime == null) {
                os.packBoolean(false);
            } else {
                os.packBoolean(true);
                os.packLong(this.finishTime.toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            os.packString(this.status.name());
        }
        catch (IOException e) {
            LRALogger.i18nLogger.warn_saveState(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("saved");
            }
        }
        return true;
    }

    private boolean save_list(OutputObjectState os, int ot, RecordList list) {
        if (list != null && list.size() > 0) {
            AbstractRecord temp;
            AbstractRecord first = temp = list.getFront();
            while (temp != null) {
                list.putRear(temp);
                if (!temp.doSave()) {
                    return false;
                }
                try {
                    os.packInt(temp.typeIs());
                    if (!temp.save_state(os, ot)) {
                        return false;
                    }
                }
                catch (IOException e) {
                    return false;
                }
                temp = list.getFront();
                if (temp != first) continue;
                list.putFront(temp);
                temp = null;
            }
        }
        try {
            os.packInt(463);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean restore_list(InputObjectState os, int ot, RecordList list) {
        int record_type = 463;
        try {
            while ((record_type = os.unpackInt()) != 463) {
                AbstractRecord record = AbstractRecord.create((int)record_type);
                if (record == null || !record.restore_state(os, ot) || !list.insert(record)) {
                    return false;
                }
                if (!(record instanceof LRAParticipantRecord)) continue;
                LRAParticipantRecord lraRecord = (LRAParticipantRecord)record;
                lraRecord.setLRAService(this.lraService);
                lraRecord.setLRA(this);
            }
        }
        catch (IOException | NullPointerException e1) {
            LRALogger.i18nLogger.warn_coordinatorNorecordfound(Integer.toString(record_type), (Throwable)e1);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restore_state(InputObjectState os, int ot) {
        if (!super.restore_state(os, ot) || !this.restore_list(os, ot, this.pendingList)) {
            return false;
        }
        AbstractRecord rec = this.preparedList.peekFront();
        while (rec != null) {
            LRAParticipantRecord p;
            if (rec instanceof LRAParticipantRecord && (p = (LRAParticipantRecord)rec).isFailed()) {
                this.preparedList.remove((AbstractRecord)p);
                AbstractRecord r = this.failedList.peekFront();
                while (r != null && !p.equals(r)) {
                    r = this.failedList.peekNext(r);
                }
                if (r == null) {
                    this.failedList.putFront((AbstractRecord)p);
                }
            }
            rec = this.preparedList.peekNext(rec);
        }
        try {
            String s = os.unpackString();
            this.id = s == null ? null : new URI(s);
            s = os.unpackString();
            if (s == null) {
                this.parentId = null;
            } else {
                this.parentId = new URI(s);
                LongRunningAction localParent = this.lraService.lookupTransaction(this.parentId);
                if (localParent != null && this.par == null && !this.linkChildWithParent(localParent)) {
                    LRALogger.i18nLogger.warn_restoreState("add parent/child failed");
                    boolean bl = false;
                    return bl;
                }
            }
            this.clientId = os.unpackString();
            this.startTime = os.unpackBoolean() ? LocalDateTime.ofInstant(Instant.ofEpochMilli(os.unpackLong()), ZoneOffset.UTC) : null;
            this.finishTime = os.unpackBoolean() ? LocalDateTime.ofInstant(Instant.ofEpochMilli(os.unpackLong()), ZoneOffset.UTC) : null;
            this.status = LRAStatus.valueOf((String)os.unpackString());
            if (this.finishTime != null) {
                long ttl = ChronoUnit.MILLIS.between(LocalDateTime.now(ZoneOffset.UTC), this.finishTime);
                if (ttl <= 0L) {
                    if (LRALogger.logger.isDebugEnabled()) {
                        LRALogger.logger.debugf("Timer for LRA '%s' has expired since last reload", (Object)this.id);
                    }
                    if (this.status == LRAStatus.Active) {
                        this.status = LRAStatus.Cancelling;
                    }
                } else if (LRALogger.logger.isDebugEnabled()) {
                    LRALogger.logger.debugf("Restarting time for LRA '%s'", (Object)this.id);
                }
                this.setTimeLimit(ttl);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | URISyntaxException e) {
            if (LRALogger.logger.isDebugEnabled()) {
                LRALogger.logger.debugf((Throwable)e, "Cannot restore state of object type '%s'", ot);
            }
            LRALogger.i18nLogger.warn_restoreState(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("restored");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongRunningAction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LongRunningAction that = (LongRunningAction)((Object)o);
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getId().hashCode();
        return result;
    }

    public static String getType() {
        return LRA_TYPE;
    }

    public String type() {
        return LongRunningAction.getType();
    }

    public URI getId() {
        return this.id;
    }

    public String getClientId() {
        return this.clientId;
    }

    protected LRAService getLraService() {
        return this.lraService;
    }

    public LRAStatus getLRAStatus() {
        return this.status;
    }

    public boolean isRecovering() {
        return this.status.equals((Object)LRAStatus.Cancelling) || this.status.equals((Object)LRAStatus.Closing);
    }

    public boolean isFailed() {
        return this.status.equals((Object)LRAStatus.FailedToCancel) || this.status.equals((Object)LRAStatus.FailedToClose);
    }

    public boolean isCancel() {
        switch (this.status) {
            case Cancelling: 
            case Cancelled: 
            case FailedToCancel: {
                return true;
            }
        }
        return false;
    }

    boolean isFinished() {
        switch (this.status) {
            case Cancelled: 
            case FailedToCancel: 
            case Closed: 
            case FailedToClose: {
                return true;
            }
        }
        return this.getSize(this.pendingList) == 0 && this.getSize(this.preparedList) == 0 && this.getSize(this.heuristicList) == 0;
    }

    protected ReentrantLock tryLockTransaction() {
        return this.lraService.tryLockTransaction(this.getId());
    }

    public int finishLRA(boolean cancel) {
        return this.finishLRA(cancel, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int finishLRA(boolean cancel, String compensator, String userData) {
        ReentrantLock lock = null;
        if (this.finishTime != null && !cancel && ChronoUnit.MILLIS.between(LocalDateTime.now(ZoneOffset.UTC), this.finishTime) <= 0L) {
            cancel = true;
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("finishing with cancel");
            }
        } else if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("finishing");
        }
        try {
            lock = this.lraService.tryLockTransaction(this.getId());
            if (lock == null) {
                if (LRALogger.logger.isInfoEnabled()) {
                    LRALogger.logger.debugf("LongRunningAction.endLRA Some other thread is finishing LRA %s", (Object)this.getId().toASCIIString());
                }
                int n = this.status();
                return n;
            }
            if (userData != null && !userData.isEmpty() && compensator != null && !compensator.isEmpty()) {
                this.updateCompensatorUserData(compensator, userData);
            }
            if (this.status == LRAStatus.Cancelling) {
                int n = this.doEnd(true);
                return n;
            }
            int n = this.doEnd(cancel);
            return n;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int doEnd(boolean cancel) {
        boolean nested;
        int res;
        block29: {
            block30: {
                res = this.status();
                boolean bl = nested = !this.isTopLevel();
                if (this.status == LRAStatus.Active) {
                    this.updateState(cancel ? LRAStatus.Cancelling : LRAStatus.Closing);
                } else if (this.isFinished()) {
                    if (LRALogger.logger.isTraceEnabled()) {
                        this.trace_progress("finished");
                    }
                    return res;
                }
                if (this.scheduledAbort != null) {
                    this.scheduledAbort.cancel(false);
                    this.scheduledAbort = null;
                }
                this.savePendingList();
                if (res == 0 || res == 3) break block30;
                if (!nested) break block29;
                if (cancel) {
                    if (this.pendingList == null) {
                        this.pendingList = new RecordList();
                    }
                    if (this.preparedList == null) {
                        this.preparedList = new RecordList();
                    }
                    if (this.failedList == null) {
                        this.failedList = new RecordList();
                    }
                    this.moveTo(this.pendingList, this.preparedList);
                    this.moveTo(this.heuristicList, this.preparedList);
                    this.updateState(LRAStatus.Cancelling);
                    if (LRALogger.logger.isTraceEnabled()) {
                        this.trace_progress("phase2Commit for nested cancel");
                    }
                    super.phase2Commit(true);
                    res = this.status();
                    this.updateState(this.toLRAStatus(this.status()));
                    break block29;
                } else if (this.forgetAllParticipants()) {
                    this.updateState(LRAStatus.Closed);
                    break block29;
                } else {
                    if (LRALogger.logger.isTraceEnabled()) {
                        this.trace_progress("H_HAZARD forget failed");
                    }
                    return 14;
                }
            }
            if (cancel || this.status() == 3) {
                this.preparedList = new RecordList();
                this.failedList = new RecordList();
                this.moveTo(this.pendingList, this.preparedList);
                this.moveTo(this.heuristicList, this.preparedList);
                this.updateState(LRAStatus.Cancelling);
                if (this.heuristicList == null) {
                    this.heuristicList = new RecordList();
                }
                if (LRALogger.logger.isTraceEnabled()) {
                    this.trace_progress("doEnd with cancel");
                }
                super.phase2Commit(true);
                res = super.status();
            } else {
                this.updateState(LRAStatus.Closing);
                if (LRALogger.logger.isTraceEnabled()) {
                    this.trace_progress("doEnd with close");
                }
                res = super.End(true);
            }
        }
        this.runPostLRAActions();
        if (this.pending != null && !this.pending.isEmpty() && !nested) {
            this.pending.clear();
        }
        if (this.getSize(this.heuristicList) != 0) {
            this.updateState(cancel ? LRAStatus.Cancelling : LRAStatus.Closing);
        } else if (this.getSize(this.failedList) != 0) {
            this.updateState(cancel ? LRAStatus.FailedToCancel : LRAStatus.FailedToClose);
        } else if (this.getSize(this.pendingList) != 0 || this.getSize(this.preparedList) != 0) {
            this.updateState(LRAStatus.Closing);
        }
        if (this.isTopLevel()) {
            this.finishTime = LocalDateTime.now(ZoneOffset.UTC);
        }
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("doEnd update finishTime");
        }
        this.updateState();
        if (!this.isRecovering()) {
            this.lraService.finished(this, false);
        }
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("doEnd finished");
        }
        return res;
    }

    protected void runPostLRAActions() {
        if (this.isInEndState() && this.heuristicList != null && this.heuristicList.size() != 0) {
            if (this.preparedList == null) {
                this.preparedList = new RecordList();
            }
            this.moveTo(this.heuristicList, this.preparedList);
            this.checkParticipant(this.preparedList);
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("runPostLRAActions");
            }
            super.phase2Commit(true);
        }
    }

    protected void updateState(LRAStatus nextState) {
        if (this.status != nextState) {
            this.status = nextState;
            if (this.pendingList != null && this.pendingList.size() != 0) {
                this.deactivate();
            }
        }
    }

    protected void checkParticipant(RecordList participants) {
        AbstractRecord r;
        RecordListIterator i = new RecordListIterator(participants);
        while ((r = i.iterate()) != null) {
            if (!(r instanceof LRAParticipantRecord)) continue;
            LRAParticipantRecord rec = (LRAParticipantRecord)r;
            rec.setLraService(this.getLraService());
            rec.setLRA(this);
        }
    }

    protected void moveTo(RecordList fromList, RecordList toList) {
        if (fromList != null) {
            AbstractRecord record;
            while ((record = fromList.getFront()) != null) {
                toList.putFront(record);
            }
        }
    }

    private boolean allFinished(RecordList ... lists) {
        for (RecordList list : lists) {
            AbstractRecord r;
            if (list == null) continue;
            RecordListIterator i = new RecordListIterator(list);
            while ((r = i.iterate()) != null) {
                LRAParticipantRecord rec;
                if (!(r instanceof LRAParticipantRecord) || (rec = (LRAParticipantRecord)r).isFinished()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isInEndState() {
        if (this.status == LRAStatus.Cancelling && this.allFinished(this.heuristicList, this.failedList)) {
            this.updateState(this.failedList == null || this.failedList.size() == 0 ? LRAStatus.Cancelled : LRAStatus.FailedToCancel);
        } else if (this.status == LRAStatus.Closing && this.allFinished(this.heuristicList, this.failedList)) {
            this.updateState(this.failedList == null || this.failedList.size() == 0 ? LRAStatus.Closed : LRAStatus.FailedToClose);
        }
        return this.isFinished();
    }

    private int getSize(RecordList list) {
        return list == null ? 0 : list.size();
    }

    protected LRAStatus toLRAStatus(int atomicActionStatus) {
        switch (atomicActionStatus) {
            case 2: 
            case 3: 
            case 6: {
                return this.status == LRAStatus.Cancelling ? LRAStatus.Cancelling : LRAStatus.Closing;
            }
            case 4: 
            case 11: {
                return this.status == LRAStatus.Cancelling ? LRAStatus.Cancelled : LRAStatus.Closed;
            }
            case 7: {
                return this.status == LRAStatus.Cancelling ? LRAStatus.Cancelled : LRAStatus.Closed;
            }
        }
        return LRAStatus.Active;
    }

    public LRAParticipantRecord enlistParticipant(URI coordinatorUrl, String participantUrl, String recoveryUrlBase, long timeLimit, String compensatorData) throws UnsupportedEncodingException {
        LRAParticipantRecord participant = this.findLRAParticipant(participantUrl, false);
        if (participant != null) {
            participant.setCompensatorData(compensatorData);
            return participant;
        }
        participant = this.doEnlistParticipant(coordinatorUrl, participantUrl, recoveryUrlBase, timeLimit, compensatorData);
        if (participant != null) {
            this.deactivate();
            this.savedIntentionList = true;
        }
        return participant;
    }

    private LRAParticipantRecord doEnlistParticipant(URI coordinatorUrl, String participantUrl, String recoveryUrlBase, long timeLimit, String compensatorData) {
        LRAParticipantRecord p = new LRAParticipantRecord(this, this.lraService, participantUrl, compensatorData);
        String pid = p.get_uid().fileStringForm();
        String txId = URLEncoder.encode(coordinatorUrl.toASCIIString(), StandardCharsets.UTF_8);
        p.setRecoveryURI(recoveryUrlBase, txId, pid);
        if (this.add(p) != 3) {
            this.setTimeLimit(timeLimit);
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("enlisted " + p.getParticipantPath());
            }
            return p;
        }
        if (this.isRecovering() && p.getCompensator() == null && p.getEndNotificationUri() != null) {
            this.heuristicList.putRear((AbstractRecord)p);
            this.updateState();
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("enlisted listener " + p.getParticipantPath());
            }
            return p;
        }
        return null;
    }

    private void updateCompensatorUserData(String compensator, String userData) {
        LRAParticipantRecord participant = this.findLRAParticipant(compensator, false);
        if (participant != null) {
            participant.setCompensatorData(userData);
        } else {
            LRALogger.i18nLogger.warn_unknownParticipant(compensator);
        }
    }

    public boolean forgetParticipant(String participantUrl) {
        return this.findLRAParticipant(participantUrl, true) != null;
    }

    public boolean forgetAllParticipants() {
        if (this.pending == null) {
            return true;
        }
        this.pending.removeIf(LRAParticipantRecord::forget);
        return this.pending.isEmpty();
    }

    private void savePendingList() {
        AbstractRecord r;
        if (this.pendingList == null) {
            this.savedIntentionList = true;
            return;
        }
        if (this.pending != null) {
            return;
        }
        RecordListIterator i = new RecordListIterator(this.pendingList);
        this.pending = new ArrayList<LRAParticipantRecord>();
        while ((r = i.iterate()) != null) {
            if (!(r instanceof LRAParticipantRecord)) continue;
            this.pending.add((LRAParticipantRecord)r);
        }
    }

    private LRAParticipantRecord findLRAParticipant(String participantUrl, boolean remove) {
        LRAParticipantRecord rec;
        try {
            URI recoveryUrl = new URI(LRAParticipantRecord.cannonicalForm(participantUrl));
            rec = this.findLRAParticipantByRecoveryUrl(recoveryUrl, remove, this.pendingList, this.preparedList, this.heuristicList, this.failedList);
        }
        catch (URISyntaxException ignore) {
            String pUrl;
            try {
                pUrl = LRAParticipantRecord.extractCompensator(participantUrl);
            }
            catch (URISyntaxException e) {
                return null;
            }
            rec = this.findLRAParticipant(pUrl, remove, this.pendingList, this.preparedList, this.heuristicList, this.failedList);
        }
        return rec;
    }

    private LRAParticipantRecord findLRAParticipant(String participantUrl, boolean remove, RecordList ... lists) {
        for (RecordList list : lists) {
            AbstractRecord r;
            if (list == null) continue;
            RecordListIterator i = new RecordListIterator(list);
            if (participantUrl.indexOf(44) != -1) {
                try {
                    participantUrl = LRAParticipantRecord.extractCompensator(participantUrl);
                }
                catch (URISyntaxException e) {
                    continue;
                }
            }
            while ((r = i.iterate()) != null) {
                LRAParticipantRecord rr;
                if (!(r instanceof LRAParticipantRecord) || !participantUrl.equals((rr = (LRAParticipantRecord)r).getCompensator())) continue;
                if (remove) {
                    list.remove((AbstractRecord)rr);
                }
                return rr;
            }
        }
        return null;
    }

    private LRAParticipantRecord findLRAParticipantByRecoveryUrl(URI recoveryUrl, boolean remove, RecordList ... lists) {
        for (RecordList list : lists) {
            AbstractRecord r;
            if (list == null) continue;
            RecordListIterator i = new RecordListIterator(list);
            while ((r = i.iterate()) != null) {
                LRAParticipantRecord rr;
                if (!(r instanceof LRAParticipantRecord) || !(rr = (LRAParticipantRecord)r).getRecoveryURI().equals(recoveryUrl)) continue;
                if (remove) {
                    list.remove((AbstractRecord)rr);
                }
                return rr;
            }
        }
        return null;
    }

    public boolean isTopLevel() {
        return this.parentId == null;
    }

    public int getHttpStatus() {
        switch (this.status()) {
            case 4: 
            case 7: {
                return 200;
            }
        }
        return this.lraStatusToHttpStatus();
    }

    private int lraStatusToHttpStatus() {
        if (this.status == null || this.status == LRAStatus.Active) {
            return Response.Status.NO_CONTENT.getStatusCode();
        }
        switch (this.status) {
            case Cancelled: 
            case Closed: {
                return Response.Status.OK.getStatusCode();
            }
            case Cancelling: 
            case Closing: {
                return Response.Status.ACCEPTED.getStatusCode();
            }
            case FailedToCancel: 
            case FailedToClose: {
                return Response.Status.PRECONDITION_FAILED.getStatusCode();
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    }

    public int begin(Long timeLimit) {
        LongRunningAction localParent;
        if (this.status() != 8) {
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("begin: already running");
            }
            return this.status();
        }
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("begin");
        }
        int res = super.Begin(null);
        if (this.parentId != null && (localParent = this.lraService.lookupTransaction(this.parentId)) != null && !this.linkChildWithParent(localParent)) {
            return 9;
        }
        this.startTime = LocalDateTime.now(ZoneOffset.UTC);
        this.setTimeLimit(timeLimit);
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("begin, deactivating");
        }
        this.deactivate();
        return res;
    }

    private boolean linkChildWithParent(LongRunningAction localParent) {
        this.par = new LRAParentAbstractRecord(localParent, this);
        if (localParent.add(this.par) != 2) {
            return false;
        }
        LRAChildAbstractRecord childAR = new LRAChildAbstractRecord(this.par);
        return this.add(childAR) != 3;
    }

    public int setTimeLimit(Long timeLimit) {
        if (timeLimit <= 0L) {
            return Response.Status.OK.getStatusCode();
        }
        return this.scheduleCancellation(this::abortLRA, timeLimit);
    }

    private int scheduleCancellation(Runnable runnable, Long timeLimit) {
        assert (timeLimit > 0L);
        if (this.status() != 0) {
            if (LRALogger.logger.isDebugEnabled()) {
                LRALogger.logger.debugf("Ignoring timer because the action status is `%e'", this.status());
            }
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("scheduleCancellation: wrong state");
            }
            return Response.Status.PRECONDITION_FAILED.getStatusCode();
        }
        if (this.finishTime != null) {
            LocalDateTime ft = LocalDateTime.now(ZoneOffset.UTC).plusNanos(timeLimit * 1000000L);
            if (ft.isAfter(this.finishTime)) {
                return Response.Status.OK.getStatusCode();
            }
            this.finishTime = ft;
            if (this.scheduledAbort != null) {
                if (LRALogger.logger.isTraceEnabled()) {
                    this.trace_progress("scheduleCancellation: earlier than previous timer");
                }
                this.scheduledAbort.cancel(false);
            }
        } else {
            this.finishTime = LocalDateTime.now(ZoneOffset.UTC).plusNanos(timeLimit * 1000000L);
        }
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("scheduleCancellation update finishTime");
        }
        try {
            this.scheduledAbort = scheduler.schedule(runnable, (long)timeLimit, TimeUnit.MILLISECONDS);
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("scheduleCancellation accepted");
            }
        }
        catch (RejectedExecutionException executionException) {
            this.updateState(LRAStatus.Cancelling);
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("scheduleCancellation rejected");
            }
            LRALogger.logger.warnf("The LRA transaction with ID %s has not correctly scheduled the task to cancel itself.A recovery cycle will eventually cancel this LRA.\nException message: %s", (Object)this.getId(), (Object)executionException.getMessage());
        }
        return Response.Status.OK.getStatusCode();
    }

    private void abortLRA() {
        ReentrantLock lock = this.tryLockTransaction();
        if (lock != null) {
            try {
                int actionStatus = this.status();
                this.scheduledAbort = null;
                if (actionStatus == 0 || actionStatus == 3) {
                    if (LRALogger.logger.isDebugEnabled()) {
                        LRALogger.logger.debugf("LongRunningAction.abortLRA cancelling LRA `%s", (Object)this.id);
                    }
                    this.updateState(LRAStatus.Cancelling);
                    if (LRALogger.logger.isTraceEnabled()) {
                        this.trace_progress("scheduledAbort fired");
                    }
                    this.finishLRA(true);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void updateRecoveryURI(String compensatorUri, String recoveryUri) {
        block4: {
            LRAParticipantRecord lraRecord = this.findLRAParticipant(compensatorUri, false);
            if (lraRecord != null) {
                try {
                    lraRecord.setRecoveryURI(recoveryUri);
                    if (!this.deactivate() && LRALogger.logger.isInfoEnabled()) {
                        LRALogger.logger.infof("Could not save new recovery URL", new Object[0]);
                    }
                }
                catch (WebApplicationException e) {
                    if (!LRALogger.logger.isInfoEnabled()) break block4;
                    LRALogger.logger.infof("Could not save new recovery URL: %s", (Object)e.getMessage());
                }
            }
        }
    }

    public URI getParentId() {
        return this.parentId;
    }

    private boolean hasElements(RecordList list) {
        return list != null && list.size() != 0;
    }

    public boolean hasPendingActions() {
        return !this.isFinished() || this.hasElements(this.heuristicList);
    }

    void forget() {
        if (this.heuristicList != null && this.heuristicList.size() != 0) {
            AbstractRecord r;
            RecordListIterator i = new RecordListIterator(this.heuristicList);
            while ((r = i.iterate()) != null) {
                if (!(r instanceof LRAParticipantRecord)) continue;
                LRAParticipantRecord rec = (LRAParticipantRecord)r;
                rec.forget();
            }
        }
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("forget okay");
        }
    }

    private void trace_progress(String reason) {
        LRALogger.logger.tracef("%s: LRA id: %s (%s) parent: %s reason: %s state: %s created: %s ttl: %s", new Object[]{LocalDateTime.now(ZoneOffset.UTC), this.id, this.clientId, this.parentId == null ? "" : this.parentId, reason, this.status, this.startTime, this.finishTime});
    }
}

