/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.lowlevel.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.gson.impl.GsonUtils;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.Analysis;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.PropertyMappingIndexSettingsContributor;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.metadata.impl.ElasticsearchIndexMetadataSyntax;

public class LowLevelIndexMetadataBuilder {
    private final GsonProvider gsonProvider;
    private final ElasticsearchIndexMetadataSyntax syntax;
    private final IndexNames indexNames;
    private PropertyMappingIndexSettingsContributor propertyMappingIndexSettingsContributor;
    private ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private IndexSettings customIndexSettings;
    private RootTypeMapping mapping;
    private RootTypeMapping customMapping;

    public LowLevelIndexMetadataBuilder(GsonProvider gsonProvider, ElasticsearchIndexMetadataSyntax syntax, IndexNames indexNames) {
        this.gsonProvider = gsonProvider;
        this.syntax = syntax;
        this.indexNames = indexNames;
    }

    public void setAnalysisDefinitionRegistry(ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
    }

    public void setCustomIndexSettings(IndexSettings customIndexSettings) {
        this.customIndexSettings = customIndexSettings;
    }

    public void setPropertyMappingIndexSettingsContributor(PropertyMappingIndexSettingsContributor propertyMappingIndexSettingsContributor) {
        this.propertyMappingIndexSettingsContributor = propertyMappingIndexSettingsContributor;
    }

    public void setMapping(RootTypeMapping mapping) {
        this.mapping = mapping;
    }

    public void setCustomMapping(RootTypeMapping customMapping) {
        this.customMapping = customMapping;
    }

    public IndexMetadata build() {
        IndexMetadata indexMetadata = new IndexMetadata();
        indexMetadata.setAliases(this.buildAliases());
        indexMetadata.setSettings(this.buildSettings());
        indexMetadata.setMapping(this.buildMapping());
        return indexMetadata;
    }

    private Map<String, IndexAliasDefinition> buildAliases() {
        LinkedHashMap<String, IndexAliasDefinition> aliases = new LinkedHashMap<String, IndexAliasDefinition>();
        if (this.indexNames.writeIsAlias()) {
            aliases.put(this.indexNames.write().original, this.syntax.createWriteAliasDefinition());
        }
        if (this.indexNames.readIsAlias()) {
            aliases.put(this.indexNames.read().original, this.syntax.createReadAliasDefinition());
        }
        return aliases;
    }

    private IndexSettings buildSettings() {
        IndexSettings settings = new IndexSettings();
        if (this.propertyMappingIndexSettingsContributor != null) {
            this.propertyMappingIndexSettingsContributor.contribute(settings);
        }
        if (!this.analysisDefinitionRegistry.getAnalyzerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setAnalyzers(this.analysisDefinitionRegistry.getAnalyzerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getNormalizerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setNormalizers(this.analysisDefinitionRegistry.getNormalizerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getTokenizerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setTokenizers(this.analysisDefinitionRegistry.getTokenizerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getTokenFilterDefinitions().isEmpty()) {
            this.getAnalysis(settings).setTokenFilters(this.analysisDefinitionRegistry.getTokenFilterDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getCharFilterDefinitions().isEmpty()) {
            this.getAnalysis(settings).setCharFilters(this.analysisDefinitionRegistry.getCharFilterDefinitions());
        }
        if (this.customIndexSettings == null) {
            return settings;
        }
        IndexSettings customIndexSettingsCopy = GsonUtils.deepCopy(this.gsonProvider.getGsonNoSerializeNulls(), IndexSettings.class, this.customIndexSettings);
        customIndexSettingsCopy.merge(settings);
        return customIndexSettingsCopy;
    }

    private RootTypeMapping buildMapping() {
        if (this.customMapping == null) {
            return this.mapping;
        }
        RootTypeMapping customMappingCopy = GsonUtils.deepCopy(this.gsonProvider.getGsonNoSerializeNulls(), RootTypeMapping.class, this.customMapping);
        RootTypeMapping hibernateSearchMappingCopy = GsonUtils.deepCopy(this.gsonProvider.getGsonNoSerializeNulls(), RootTypeMapping.class, this.mapping);
        customMappingCopy.merge(hibernateSearchMappingCopy);
        return customMappingCopy;
    }

    private Analysis getAnalysis(IndexSettings settings) {
        Analysis analysis = settings.getAnalysis();
        if (analysis == null) {
            analysis = new Analysis();
            settings.setAnalysis(analysis);
        }
        return analysis;
    }
}

