/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public class ElasticsearchShortFieldCodec
implements ElasticsearchFieldCodec<Short> {
    public static final ElasticsearchShortFieldCodec INSTANCE = new ElasticsearchShortFieldCodec();

    private ElasticsearchShortFieldCodec() {
    }

    @Override
    public JsonElement encode(Short value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Short decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.SHORT.fromElement(element);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return INSTANCE == other;
    }
}

