/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.ee.structure.EJBAnnotationPropertyReplacement;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.spi.DeploymentUnitDependenciesProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.msc.service.ServiceName;

public class ResourceLookupDependenciesProvider
implements DeploymentUnitDependenciesProvider {
    private static final DotName RESOURCE_ANNOTATION_NAME = DotName.createSimple((String)Resource.class.getName());

    public Set<ServiceName> getDependencies(DeploymentUnit unit) {
        CompositeIndex index = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        PropertyReplacer replacer = EJBAnnotationPropertyReplacement.propertyReplacer((DeploymentUnit)unit);
        List annotations = index.getAnnotations(RESOURCE_ANNOTATION_NAME);
        TreeSet<ServiceName> result = !annotations.isEmpty() ? new TreeSet<ServiceName>() : Collections.emptySet();
        for (AnnotationInstance annotation : annotations) {
            AnnotationValue lookupValue = annotation.value("lookup");
            if (lookupValue == null) continue;
            String lookup = replacer.replaceProperties(lookupValue.asString());
            try {
                ServiceName name = ContextNames.bindInfoFor((String)lookup).getBinderServiceName();
                if (!ContextNames.JBOSS_CONTEXT_SERVICE_NAME.isParentOf(name)) continue;
                result.add(name);
            }
            catch (RuntimeException runtimeException) {}
        }
        return result;
    }
}

