/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.EnumSet;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.xml.VersionedNamespace;
import org.jboss.as.version.Stability;
import org.jboss.staxmapper.IntVersion;
import org.jboss.staxmapper.Versioned;
import org.wildfly.extension.elytron.AuditLoggingParser;
import org.wildfly.extension.elytron.AuthenticationClientParser;
import org.wildfly.extension.elytron.CredentialSecurityFactoryParser;
import org.wildfly.extension.elytron.CredentialStoreParser;
import org.wildfly.extension.elytron.DirContextDefinition;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ExpressionResolverResourceDefinition;
import org.wildfly.extension.elytron.HttpParser;
import org.wildfly.extension.elytron.JaspiConfigurationParser;
import org.wildfly.extension.elytron.MapperParser;
import org.wildfly.extension.elytron.PermissionMapperDefinitions;
import org.wildfly.extension.elytron.PermissionSetDefinition;
import org.wildfly.extension.elytron.PolicyParser;
import org.wildfly.extension.elytron.ProviderParser;
import org.wildfly.extension.elytron.RealmParser;
import org.wildfly.extension.elytron.SSLDefinitions;
import org.wildfly.extension.elytron.SaslParser;
import org.wildfly.extension.elytron.SecurityDomainParser;
import org.wildfly.extension.elytron.TlsParser;

public enum ElytronSubsystemSchema implements PersistentSubsystemSchema<ElytronSubsystemSchema>
{
    VERSION_1_0(1),
    VERSION_1_1(1, 1),
    VERSION_1_2(1, 2),
    VERSION_2_0(2),
    VERSION_3_0(3),
    VERSION_4_0(4),
    VERSION_5_0(5),
    VERSION_6_0(6),
    VERSION_7_0(7),
    VERSION_8_0(8),
    VERSION_9_0(9),
    VERSION_10_0(10),
    VERSION_11_0(11),
    VERSION_12_0(12),
    VERSION_13_0(13),
    VERSION_14_0(14),
    VERSION_15_0(15),
    VERSION_15_1(15, 1),
    VERSION_16_0(16),
    VERSION_17_0(17),
    VERSION_18_0(18),
    VERSION_18_0_COMMUNITY(18, Stability.COMMUNITY);

    static final Map<Stability, ElytronSubsystemSchema> CURRENT;
    private final VersionedNamespace<IntVersion, ElytronSubsystemSchema> namespace;

    private ElytronSubsystemSchema(int major) {
        this.namespace = SubsystemSchema.createSubsystemURN((String)"elytron", (IntVersion)new IntVersion(new int[]{major}));
    }

    private ElytronSubsystemSchema(int major, int minor) {
        this.namespace = SubsystemSchema.createSubsystemURN((String)"elytron", (IntVersion)new IntVersion(new int[]{major, minor}));
    }

    private ElytronSubsystemSchema(int major, Stability stability) {
        this.namespace = SubsystemSchema.createSubsystemURN((String)"elytron", (Stability)stability, (IntVersion)new IntVersion(new int[]{major}));
    }

    public VersionedNamespace<IntVersion, ElytronSubsystemSchema> getNamespace() {
        return this.namespace;
    }

    public PersistentResourceXMLDescription getXMLDescription() {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)ElytronExtension.SUBSYSTEM_PATH, this.getNamespace());
        if (this.since((Versioned)VERSION_1_0)) {
            builder.addAttribute((AttributeDefinition)ElytronDefinition.DEFAULT_AUTHENTICATION_CONTEXT).addAttribute((AttributeDefinition)ElytronDefinition.INITIAL_PROVIDERS).addAttribute((AttributeDefinition)ElytronDefinition.FINAL_PROVIDERS).addAttribute((AttributeDefinition)ElytronDefinition.DISALLOWED_PROVIDERS).addAttribute((AttributeDefinition)ElytronDefinition.SECURITY_PROPERTIES, (AttributeParser)new AttributeParsers.PropertiesParser(null, "security-property", true), (AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller(null, "security-property", true));
        }
        if (this.since((Versioned)VERSION_5_0)) {
            builder.addAttribute((AttributeDefinition)ElytronDefinition.REGISTER_JASPI_FACTORY).addAttribute((AttributeDefinition)ElytronDefinition.DEFAULT_SSL_CONTEXT);
        }
        this.addAuthenticationClientParser(builder);
        this.addProviderParser(builder);
        this.addAuditLoggingParser(builder);
        this.addSecurityDomainParser(builder);
        this.addRealmParser(builder);
        this.addCredentialSecurityFactoryParser(builder);
        this.addMapperParser(builder);
        this.addPermissionSetParser(builder);
        this.addHttpParser(builder);
        this.addSaslParser(builder);
        this.addTlsParser(builder);
        this.addCredentialStoreParser(builder);
        this.addExpressionResolverParser(builder);
        this.addDirContextParser(builder);
        this.addPolicyParser(builder);
        this.addJaspiConfigurationParser(builder);
        return builder.build();
    }

    private void addJaspiConfigurationParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        if (this.since((Versioned)VERSION_5_0)) {
            builder.addChild(new JaspiConfigurationParser().jaspiConfigurationParser_5_0);
        }
    }

    private void addDirContextParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(PersistentResourceXMLDescription.decorator((String)"dir-contexts").addChild(PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"dir-context")).addAttributes(DirContextDefinition.ATTRIBUTES)).build());
        }
    }

    private void addExpressionResolverParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        if (this.since((Versioned)VERSION_13_0)) {
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"expression", (String)"encryption")).setXmlElementName("expression-resolver").addAttribute((AttributeDefinition)ExpressionResolverResourceDefinition.RESOLVERS).addAttribute((AttributeDefinition)ExpressionResolverResourceDefinition.DEFAULT_RESOLVER).addAttribute((AttributeDefinition)ExpressionResolverResourceDefinition.PREFIX).build());
        }
    }

    private void addSaslParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(new SaslParser().parser);
        }
    }

    private void addHttpParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(new HttpParser().parser);
        }
    }

    private void addPermissionSetParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        if (this.since((Versioned)VERSION_3_0)) {
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)PermissionSetDefinition.getPermissionSet().getPathElement()).setXmlWrapperElement("permission-sets").addAttribute((AttributeDefinition)PermissionMapperDefinitions.PERMISSIONS).build());
        }
    }

    private void addCredentialSecurityFactoryParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(new CredentialSecurityFactoryParser().parser);
        }
    }

    private void addProviderParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(new ProviderParser().parser);
        }
    }

    private void addPolicyParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        PolicyParser policyParser = new PolicyParser();
        if (this.since((Versioned)VERSION_1_2)) {
            builder.addChild(policyParser.parser_1_2);
        } else if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(policyParser.parser_1_0);
        }
    }

    private void addCredentialStoreParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        CredentialStoreParser credentialStoreParser = new CredentialStoreParser();
        if (this.since((Versioned)VERSION_13_0)) {
            builder.addChild(credentialStoreParser.getCredentialStoresParser_13().build());
        } else if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(credentialStoreParser.getCredentialStoresParser().build());
        }
    }

    private void addTlsParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        TlsParser tlsParser = new TlsParser();
        if (this.since((Versioned)VERSION_18_0_COMMUNITY) && this.enables((Feature)SSLDefinitions.getDynamicClientSSLContextDefinition())) {
            builder.addChild(tlsParser.tlsParserCommunity_18_0);
        } else if (this.since((Versioned)VERSION_14_0)) {
            builder.addChild(tlsParser.tlsParser_14_0);
        } else if (this.since((Versioned)VERSION_12_0)) {
            builder.addChild(tlsParser.tlsParser_12_0);
        } else if (this.since((Versioned)VERSION_9_0)) {
            builder.addChild(tlsParser.tlsParser_9_0);
        } else if (this.since((Versioned)VERSION_8_0)) {
            builder.addChild(tlsParser.tlsParser_8_0);
        } else if (this.since((Versioned)VERSION_5_0)) {
            builder.addChild(tlsParser.tlsParser_5_0);
        } else if (this.since((Versioned)VERSION_4_0)) {
            builder.addChild(tlsParser.tlsParser_4_0);
        } else if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(tlsParser.tlsParser_1_0);
        }
    }

    private void addMapperParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        if (this.since((Versioned)VERSION_12_0)) {
            builder.addChild(new MapperParser(MapperParser.Version.VERSION_12_0).getParser());
        } else if (this.since((Versioned)VERSION_10_0)) {
            builder.addChild(new MapperParser(MapperParser.Version.VERSION_10_0).getParser());
        } else if (this.since((Versioned)VERSION_8_0)) {
            builder.addChild(new MapperParser(MapperParser.Version.VERSION_8_0).getParser());
        } else if (this.since((Versioned)VERSION_4_0)) {
            builder.addChild(new MapperParser(MapperParser.Version.VERSION_4_0).getParser());
        } else if (this.since((Versioned)VERSION_3_0)) {
            builder.addChild(new MapperParser(MapperParser.Version.VERSION_3_0).getParser());
        } else if (this.since((Versioned)VERSION_1_1)) {
            builder.addChild(new MapperParser(MapperParser.Version.VERSION_1_1).getParser());
        } else if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(new MapperParser(MapperParser.Version.VERSION_1_0).getParser());
        }
    }

    private void addRealmParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        RealmParser realmParser = new RealmParser();
        if (this.since((Versioned)VERSION_18_0)) {
            builder.addChild(realmParser.realmParser_18);
        } else if (this.since((Versioned)VERSION_16_0)) {
            builder.addChild(realmParser.realmParser_16);
        } else if (this.since((Versioned)VERSION_15_1)) {
            builder.addChild(realmParser.realmParser_15_1);
        } else if (this.since((Versioned)VERSION_15_0)) {
            builder.addChild(realmParser.realmParser_15_0);
        } else if (this.since((Versioned)VERSION_14_0)) {
            builder.addChild(realmParser.realmParser_14_0);
        } else if (this.since((Versioned)VERSION_11_0)) {
            builder.addChild(realmParser.realmParser_11_0);
        } else if (this.since((Versioned)VERSION_8_0)) {
            builder.addChild(realmParser.realmParser_8_0);
        } else if (this.since((Versioned)VERSION_7_0)) {
            builder.addChild(realmParser.realmParser_7_0);
        } else if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(realmParser.realmParser);
        }
    }

    private void addSecurityDomainParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        SecurityDomainParser securityDomainParser = new SecurityDomainParser();
        if (this.since((Versioned)VERSION_17_0)) {
            builder.addChild(securityDomainParser.parser_17_0);
        } else if (this.since((Versioned)VERSION_10_0)) {
            builder.addChild(securityDomainParser.parser_10_0);
        } else if (this.since((Versioned)VERSION_8_0)) {
            builder.addChild(securityDomainParser.parser_8_0);
        } else if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(securityDomainParser.parser_1_0);
        }
    }

    private void addAuditLoggingParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        AuditLoggingParser auditLoggingParser = new AuditLoggingParser();
        if (this.since((Versioned)VERSION_18_0)) {
            builder.addChild(auditLoggingParser.parser18_0);
        } else if (this.since((Versioned)VERSION_8_0)) {
            builder.addChild(auditLoggingParser.parser8_0);
        } else if (this.since((Versioned)VERSION_5_0)) {
            builder.addChild(auditLoggingParser.parser5_0);
        } else if (this.since((Versioned)VERSION_4_0)) {
            builder.addChild(auditLoggingParser.parser4_0);
        } else if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(auditLoggingParser.parser);
        }
    }

    private void addAuthenticationClientParser(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        AuthenticationClientParser authenticationClientParser = new AuthenticationClientParser();
        if (this.since((Versioned)VERSION_9_0)) {
            builder.addChild(authenticationClientParser.parser_9_0);
        } else if (this.since((Versioned)VERSION_1_0)) {
            builder.addChild(authenticationClientParser.parser);
        }
    }

    static {
        CURRENT = Feature.map(EnumSet.of(VERSION_18_0, VERSION_18_0_COMMUNITY));
    }
}

