/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeKeyManyToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmManyToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOnDeleteEnum;
import org.hibernate.envers.boot.model.Column;
import org.hibernate.envers.boot.model.Keyable;
import org.hibernate.envers.boot.model.PluralAttribute;
import org.hibernate.envers.internal.tools.StringTools;

public class ManyToOneAttribute
implements PluralAttribute,
Keyable {
    private final List<Column> columns;
    private final String type;
    private final boolean insertable;
    private final boolean updatable;
    private boolean key;
    private final String clazz;
    private String onDelete;
    private String name;
    private String foreignKey;

    public ManyToOneAttribute(String name, String type, boolean insertable, boolean updatable, boolean key, String explicitType) {
        this.name = name;
        this.type = type;
        this.insertable = insertable;
        this.updatable = updatable;
        this.key = key;
        this.clazz = explicitType;
        this.columns = new ArrayList<Column>();
    }

    public ManyToOneAttribute(ManyToOneAttribute other) {
        this.name = other.name;
        this.type = other.type;
        this.insertable = other.insertable;
        this.updatable = other.updatable;
        this.key = other.key;
        this.clazz = other.clazz;
        this.onDelete = other.onDelete;
        this.foreignKey = other.foreignKey;
        this.columns = new ArrayList<Column>();
        for (Column column : other.columns) {
            this.columns.add(column.deepCopy());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setKey(boolean key) {
        this.key = key;
    }

    @Override
    public boolean isKey() {
        return this.key;
    }

    public String getOnDelete() {
        return this.onDelete;
    }

    public void setOnDelete(String onDelete) {
        this.onDelete = onDelete;
    }

    @Override
    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    @Override
    public ManyToOneAttribute deepCopy() {
        return new ManyToOneAttribute(this);
    }

    @Override
    public Serializable build() {
        if (this.key) {
            return this.buildKeyManyToOne();
        }
        return this.buildManyToOne();
    }

    private JaxbHbmCompositeKeyManyToOneType buildKeyManyToOne() {
        JaxbHbmCompositeKeyManyToOneType manyToOne = new JaxbHbmCompositeKeyManyToOneType();
        manyToOne.setName(this.name);
        manyToOne.setClazz(this.clazz);
        manyToOne.setOnDelete(this.getOnDeleteEnum());
        if (!StringTools.isEmpty(this.foreignKey)) {
            manyToOne.setForeignKey(this.foreignKey);
        }
        for (Column column : this.columns) {
            manyToOne.getColumn().add(column.build());
        }
        return manyToOne;
    }

    private JaxbHbmManyToOneType buildManyToOne() {
        JaxbHbmManyToOneType manyToOne = new JaxbHbmManyToOneType();
        manyToOne.setName(this.name);
        manyToOne.setClazz(this.clazz);
        manyToOne.setInsert(Boolean.valueOf(this.insertable));
        manyToOne.setUpdate(Boolean.valueOf(this.updatable));
        manyToOne.setOnDelete(this.getOnDeleteEnum());
        if (!StringTools.isEmpty(this.foreignKey)) {
            manyToOne.setForeignKey(this.foreignKey);
        }
        for (Column column : this.columns) {
            manyToOne.getColumnOrFormula().add(column.build());
        }
        return manyToOne;
    }

    private JaxbHbmOnDeleteEnum getOnDeleteEnum() {
        if (this.onDelete != null) {
            return JaxbHbmOnDeleteEnum.fromValue((String)this.onDelete);
        }
        return null;
    }
}

