/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEnvironment;
import org.hibernate.search.mapper.pojo.massindexing.impl.MassIndexingOperationHandledFailureException;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class PojoMassIndexingFailureHandledRunnable
implements Runnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoMassIndexingNotifier notifier;
    private final MassIndexingEnvironment environment;

    protected PojoMassIndexingFailureHandledRunnable(PojoMassIndexingNotifier notifier, MassIndexingEnvironment environment) {
        this.notifier = notifier;
        this.environment = environment;
    }

    @Override
    public final void run() {
        boolean interrupted = false;
        try {
            this.beforeExecution();
            try {
                this.runWithFailureHandler();
            }
            finally {
                this.afterExecution();
            }
        }
        catch (MassIndexingOperationHandledFailureException e) {
            try {
                this.cleanUpOnFailure();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            catch (InterruptedException e2) {
                interrupted = true;
                e.addSuppressed(e2);
            }
            throw e;
        }
        catch (InterruptedException e) {
            interrupted = true;
            try {
                this.cleanUpOnInterruption();
            }
            catch (InterruptedException | RuntimeException e2) {
                e.addSuppressed(e2);
            }
            this.notifyInterrupted(e);
        }
        catch (RuntimeException e) {
            try {
                this.cleanUpOnFailure();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            catch (InterruptedException e2) {
                interrupted = true;
                e.addSuppressed(e2);
            }
            this.notifyFailure(e);
            throw new MassIndexingOperationHandledFailureException(e);
        }
        catch (Error e) {
            try {
                this.cleanUpOnFailure();
            }
            catch (Error | RuntimeException e2) {
                e.addSuppressed(e2);
            }
            catch (InterruptedException e2) {
                interrupted = true;
                e.addSuppressed(e2);
            }
            try {
                this.notifyError(e);
            }
            catch (Error | RuntimeException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (!interrupted) {
            this.notifySuccess();
        }
    }

    protected abstract void runWithFailureHandler() throws InterruptedException;

    protected abstract void cleanUpOnInterruption() throws InterruptedException;

    protected abstract void cleanUpOnFailure() throws InterruptedException;

    protected MassIndexingEnvironment.Context createMassIndexingEnvironmentContext() {
        throw new UnsupportedOperationException("There's no context supported for " + this.getClass().getSimpleName());
    }

    protected boolean supportsThreadLifecycleHooks() {
        return false;
    }

    protected void beforeExecution() {
        if (this.supportsThreadLifecycleHooks()) {
            this.getMassIndexingEnvironment().beforeExecution(this.createMassIndexingEnvironmentContext());
        }
    }

    protected void afterExecution() {
        if (this.supportsThreadLifecycleHooks()) {
            this.getMassIndexingEnvironment().afterExecution(this.createMassIndexingEnvironmentContext());
        }
    }

    protected final PojoMassIndexingNotifier getNotifier() {
        return this.notifier;
    }

    protected final MassIndexingEnvironment getMassIndexingEnvironment() {
        return this.environment;
    }

    protected void notifySuccess() {
    }

    protected void notifyError(Error error) {
        this.notifier.reportError(error);
    }

    protected void notifyInterrupted(InterruptedException exception) {
        this.notifier.reportInterrupted(exception);
        throw new MassIndexingOperationHandledFailureException(exception);
    }

    protected void notifyFailure(RuntimeException exception) {
        this.notifier.reportRunnableFailure(exception, this.operationName());
    }

    protected String operationName() {
        return log.massIndexerOperation();
    }
}

