/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.hibernate.search.backend.elasticsearch.ElasticsearchDistributionName;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchJsonObjectFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchRequestFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchResponseFormatter;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.types.Highlightable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=400000, max=408999)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_LEGACY_ES = 400000;
    public static final int ID_OFFSET = 400500;

    @Message(id=400007, value="Elasticsearch request failed: %3$s\nRequest: %1$s\nResponse: %2$s")
    public SearchException elasticsearchRequestFailed(@FormatWith(value=ElasticsearchRequestFormatter.class) ElasticsearchRequest var1, @FormatWith(value=ElasticsearchResponseFormatter.class) ElasticsearchResponse var2, String var3, @Cause Exception var4);

    @Message(id=400008, value="Elasticsearch bulked request failed: %3$s\nRequest metadata: %1$sResponse: %2$s")
    public SearchException elasticsearchBulkedRequestFailed(@FormatWith(value=ElasticsearchJsonObjectFormatter.class) JsonObject var1, @FormatWith(value=ElasticsearchJsonObjectFormatter.class) JsonObject var2, String var3, @Cause Exception var4);

    @Message(id=400010, value="Elasticsearch response indicates a timeout (HTTP status 408)")
    public SearchException elasticsearchStatus408RequestTimeout();

    @Message(id=400020, value="Unable to update mapping for index '%1$s': %2$s")
    public SearchException elasticsearchMappingUpdateFailed(String var1, String var2, @Cause Exception var3);

    @Message(id=400022, value="Invalid index status: '%1$s'. Valid statuses are: %2$s.")
    public SearchException invalidIndexStatus(String var1, List<String> var2);

    @Message(id=400024, value="Index '%1$s' failed to reach status '%2$s' after %3$sms.")
    public SearchException unexpectedIndexStatus(URLEncodedString var1, String var2, int var3, @Cause Exception var4);

    @Message(id=400034, value="Unable to retrieve index metadata from Elasticsearch: %1$s")
    public SearchException elasticsearchIndexMetadataRetrievalFailed(String var1, @Cause Throwable var2);

    @Message(id=400035, value="Unable to update schema for index '%1$s': %2$s")
    public SearchException schemaUpdateFailed(URLEncodedString var1, String var2, @Cause Exception var3);

    @Message(id=400050, value="Missing index: index names [%1$s, %2$s] do not point to any index in the Elasticsearch cluster.")
    public SearchException indexMissing(URLEncodedString var1, URLEncodedString var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=400053, value="Executing Elasticsearch query on '%s' with parameters '%s': <%s>")
    public void executingElasticsearchQuery(String var1, Map<String, String> var2, String var3);

    @Message(id=400055, value="Duplicate tokenizer definitions: '%1$s'. Tokenizer names must be unique.")
    public SearchException tokenizerNamingConflict(String var1);

    @Message(id=400056, value="Duplicate char filter definitions: '%1$s'. Char filter names must be unique.")
    public SearchException charFilterNamingConflict(String var1);

    @Message(id=400057, value="Duplicate token filter definitions: '%1$s'. Token filter names must be unique.")
    public SearchException tokenFilterNamingConflict(String var1);

    @Message(id=400067, value="Unable to update settings for index '%1$s': %2$s")
    public SearchException elasticsearchSettingsUpdateFailed(Object var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=400069, value="Closed Elasticsearch index '%1$s' automatically.")
    public void closedIndex(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=400070, value="Opened Elasticsearch index '%1$s' automatically.")
    public void openedIndex(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400073, value="Hibernate Search will connect to Elasticsearch with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.")
    public void usingPasswordOverHttp();

    @Message(id=400075, value="Unable to apply analysis configuration: %1$s")
    public SearchException unableToApplyAnalysisConfiguration(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=400076, value="Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.")
    public SearchException invalidElasticsearchAnalyzerDefinition(String var1);

    @Message(id=400077, value="Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.")
    public SearchException invalidElasticsearchTokenizerDefinition(String var1);

    @Message(id=400078, value="Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.")
    public SearchException invalidElasticsearchCharFilterDefinition(String var1);

    @Message(id=400079, value="Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.")
    public SearchException invalidElasticsearchTokenFilterDefinition(String var1);

    @Message(id=400080, value="Unable to detect the Elasticsearch version running on the cluster: %s")
    public SearchException failedToDetectElasticsearchVersion(String var1, @Cause Exception var2);

    @Message(id=400081, value="Incompatible Elasticsearch version: '%s'. Refer to the documentation to know which versions of Elasticsearch are compatible with Hibernate Search.")
    public SearchException unsupportedElasticsearchVersion(ElasticsearchVersion var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=400082, value="Executed Elasticsearch HTTP %s request to '%s' with path '%s', query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>")
    public void executedRequestWithFailure(String var1, HttpHost var2, String var3, Map<String, String> var4, int var5, long var6, int var8, String var9, String var10, String var11);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400085, value="Unknown Elasticsearch version running on the cluster: '%s'. Hibernate Search may not work correctly. Consider updating to a newer version of Hibernate Search, if any.")
    public void unknownElasticsearchVersion(ElasticsearchVersion var1);

    @Message(id=400089, value="Unable to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'. Nested exception: %3$s")
    public SearchException failedToParseElasticsearchResponse(int var1, String var2, String var3, @Cause Exception var4);

    @Message(id=400090, value="Elasticsearch response indicates a failure.")
    public SearchException elasticsearchResponseIndicatesFailure();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=400093, value="Executed Elasticsearch HTTP %s request to '%s' with path '%s', query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>")
    public void executedRequest(String var1, HttpHost var2, String var3, Map<String, String> var4, int var5, long var6, int var8, String var9, String var10, String var11);

    @Message(id=400502, value="Invalid multi-index scope: a scope cannot span both a Elasticsearch index and another type of index. Base scope: '%1$s', incompatible (Elasticsearch) index: '%2$s'.")
    public SearchException cannotMixElasticsearchScopeWithOtherType(IndexScopeBuilder var1, ElasticsearchIndexManager var2, @Param EventContext var3);

    @Message(id=400503, value="Invalid multi-index scope: a scope cannot span multiple Elasticsearch backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.")
    public SearchException cannotMixElasticsearchScopeWithOtherBackend(IndexScopeBuilder var1, ElasticsearchIndexManager var2, @Param EventContext var3);

    @Message(id=400506, value="Invalid target for Elasticsearch extension: '%1$s'. This extension can only be applied to components created by an Elasticsearch backend.")
    public SearchException elasticsearchExtensionOnUnknownType(Object var1);

    @Message(id=400508, value="Invalid search predicate: '%1$s'. You must build the predicate from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(SearchPredicate var1);

    @Message(id=400511, value="Invalid search sort: '%1$s'. You must build the sort from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchSortWithOtherSorts(SearchSort var1);

    @Message(id=400515, value="Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidMultiTenancyStrategyName(String var1, List<String> var2);

    @Message(id=400516, value="Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.")
    public SearchException tenantIdProvidedButMultiTenancyDisabled(Set<String> var1, @Param EventContext var2);

    @Message(id=400517, value="Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.")
    public SearchException multiTenancyEnabledButNoTenantIdProvided(@Param EventContext var1);

    @Message(id=400518, value="Invalid requested type for client: '%1$s'. The Elasticsearch low-level client can only be unwrapped to '%2$s'.")
    public SearchException clientUnwrappingWithUnkownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=400519, value="Invalid requested type for this backend: '%1$s'. Elasticsearch backends can only be unwrapped to '%2$s'.")
    public SearchException backendUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400520, value="Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.")
    public SearchException indexSchemaNodeNameConflict(String var1, @Param EventContext var2);

    @Message(id=400525, value="Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.")
    public SearchException invalidFieldForDocumentElement(String var1, String var2);

    @Message(id=400526, value="Missing data in the Elasticsearch response.")
    public AssertionFailure elasticsearchResponseMissingData();

    @Message(id=400529, value="Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'")
    public SearchException minimumShouldMatchConflictingConstraints(int var1);

    @Message(id=400530, value="Conflicting index names: Hibernate Search indexes '%1$s' and '%2$s' both target the Elasticsearch index name or alias '%3$s'")
    public SearchException conflictingIndexNames(String var1, String var2, String var3);

    @Message(id=400531, value="Unable to resolve index name '%1$s' to an entity type: %2$s")
    public SearchException elasticsearchResponseUnknownIndexName(String var1, String var2, @Cause Exception var3);

    @Message(id=400532, value="Unable to convert DSL argument: %1$s")
    public SearchException cannotConvertDslParameter(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=400533, value="Invalid requested type for this index manager: '%1$s'. Elasticsearch index managers can only be unwrapped to '%2$s'.")
    public SearchException indexManagerUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400534, value="Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.")
    public SearchException invalidElasticsearchTypedAnalyzerDefinition(String var1);

    @Message(id=400535, value="Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.")
    public SearchException cannotApplyAnalyzerAndNormalizer(String var1, String var2, @Param EventContext var3);

    @Message(id=400536, value="Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.")
    public SearchException cannotUseAnalyzerOnSortableField(String var1, @Param EventContext var2);

    @Message(id=400537, value="Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.")
    public SearchException analysisComponentParameterConflict(String var1, JsonElement var2, JsonElement var3);

    @Message(id=400538, value="Invalid search projection: '%1$s'. You must build the projection from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(SearchProjection<?> var1);

    @Message(id=400544, value="Unable to shut down the Elasticsearch client: %1$s")
    public SearchException unableToShutdownClient(String var1, @Cause Exception var2);

    @Message(id=400545, value="No built-in index field type for class: '%1$s'.")
    public SearchException cannotGuessFieldType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Param EventContext var2);

    @Message(id=400553, value="Full-text features (analysis, fuzziness) are not supported for fields of this type.")
    public SearchException fullTextFeaturesNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=400554, value="Incomplete field definition. You must call toReference() to complete the field definition.")
    public SearchException incompleteFieldDefinition(@Param EventContext var1);

    @Message(id=400555, value="Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.")
    public SearchException cannotCreateReferenceMultipleTimes(@Param EventContext var1);

    @Message(id=400556, value="Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example '7.0' or just '7'.")
    public SearchException invalidElasticsearchVersionWithoutDistribution(String var1, @Cause Throwable var2);

    @Message(id=400557, value="Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier' or '<distribution>:x.y.z-qualifier' or just '<distribution>', where '<distribution>' is one of %2$s (defaults to '%3$s'), 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example 'elastic:7.0', '7.0' or just '7'. Note that the format '<distribution>' without a version number is only useful for distributions that don't support version numbers, such as Amazon OpenSearch Serverless.")
    public SearchException invalidElasticsearchVersionWithOptionalDistribution(String var1, List<String> var2, String var3, @Cause Throwable var4);

    @Message(id=400558, value="Invalid Elasticsearch distribution name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidElasticsearchDistributionName(String var1, List<String> var2);

    @Message(id=400559, value="Unexpected Elasticsearch version running on the cluster: '%2$s'. Hibernate Search was configured for Elasticsearch '%1$s'.")
    public SearchException unexpectedElasticsearchVersion(ElasticsearchVersion var1, ElasticsearchVersion var2);

    @Message(id=400560, value="Cannot skip analysis on field '%1$s': the Elasticsearch backend will always normalize arguments before attempting matches on normalized fields.")
    public SearchException skipAnalysisOnNormalizedField(String var1, @Param EventContext var2);

    @Message(id=400562, value="Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.")
    public SearchException cannotUseIndexNullAsAndAnalyzer(String var1, String var2, @Param EventContext var3);

    @Message(id=400563, value="Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.")
    public SearchException multipleValuesForSingleValuedField(String var1);

    @Message(id=400564, value="Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.")
    public SearchException explainRequiresTypeName(Set<String> var1);

    @Message(id=400565, value="Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.")
    public SearchException explainRequiresTypeTargetedByQuery(Set<String> var1, String var2);

    @Message(id=400566, value="Invalid document identifier: '%2$s'. No such document in index '%1$s'.")
    public SearchException explainUnknownDocument(URLEncodedString var1, URLEncodedString var2);

    @Message(id=400567, value="Invalid index field type: missing decimal scale. Define the decimal scale explicitly.  %1$s")
    public SearchException nullDecimalScale(String var1, @Param EventContext var2);

    @Message(id=400569, value="Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.")
    public SearchException scaledNumberTooLarge(Number var1, Number var2, Number var3);

    @Message(id=400570, value="Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.")
    public SearchException invalidDecimalScale(Integer var1, @Param EventContext var2);

    @Message(id=400572, value="Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s, but the given predicate was built from a scope targeting indexes %2$s.")
    public SearchException predicateDefinedOnDifferentIndexes(SearchPredicate var1, Set<String> var2, Set<String> var3);

    @Message(id=400573, value="Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s, but the given sort was built from a scope targeting indexes %2$s.")
    public SearchException sortDefinedOnDifferentIndexes(SearchSort var1, Set<String> var2, Set<String> var3);

    @Message(id=400574, value="Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s, but the given projection was built from a scope targeting indexes %2$s.")
    public SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> var1, Set<String> var2, Set<String> var3);

    @Message(id=400576, value="Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.")
    public SearchException cannotUseAnalyzerOnAggregableField(String var1, @Param EventContext var2);

    @Message(id=400580, value="Invalid range: '%1$s'. Elasticsearch range aggregations only accept ranges in the canonical form: (-Infinity, <value>) or [<value1>, <value2>) or [<value>, +Infinity). Call Range.canonical(...) to be sure to create such a range.")
    public SearchException elasticsearchRangeAggregationRequiresCanonicalFormForRanges(Range<?> var1);

    @Message(id=400581, value="Invalid search aggregation: '%1$s'. You must build the aggregation from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherAggregations(SearchAggregation<?> var1);

    @Message(id=400582, value="Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s, but the given aggregation was built from a scope targeting indexes %2$s.")
    public SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> var1, Set<String> var2, Set<String> var3);

    @Message(id=400585, value="Duplicate aggregation definitions for key: '%1$s'")
    public SearchException duplicateAggregationKey(@FormatWith(value=AggregationKeyFormatter.class) AggregationKey<?> var1);

    @Message(id=400587, value="Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.")
    public SearchException searchAnalyzerWithoutAnalyzer(String var1, @Param EventContext var2);

    @Message(id=400588, value="Call to the bulk REST API failed: %1$s")
    public SearchException elasticsearchFailedBecauseOfBulkFailure(String var1, @Cause Throwable var2);

    @Message(id=400589, value="Invalid host/port: '%1$s'. The host/port string must use the format 'host:port', for example 'mycompany.com:9200' The URI scheme ('http://', 'https://') must not be included.")
    public SearchException invalidHostAndPort(String var1, @Cause Exception var2);

    @Message(id=400590, value="Request execution exceeded the timeout of %1$s. Request was %2$s")
    public SearchTimeoutException requestTimedOut(@FormatWith(value=DurationInSecondsAndFractionsFormatter.class) Duration var1, @FormatWith(value=ElasticsearchRequestFormatter.class) ElasticsearchRequest var2);

    @Message(id=400591, value="Invalid name for the type-name mapping strategy: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidTypeNameMappingStrategyName(String var1, List<String> var2);

    @Message(id=400592, value="Missing field '%1$s' for one of the search hits. The document was probably indexed with a different configuration: full reindexing is necessary.")
    public SearchException missingTypeFieldInDocument(String var1);

    @Message(id=400593, value="Invalid Elasticsearch index layout: index names [%1$s, %2$s] resolve to multiple distinct indexes %3$s. These names must resolve to a single index.")
    public SearchException elasticsearchIndexNameAndAliasesMatchMultipleIndexes(URLEncodedString var1, URLEncodedString var2, Set<String> var3);

    @Message(id=400594, value="Invalid Elasticsearch index layout: primary (non-alias) name for existing Elasticsearch index '%1$s' does not match the expected pattern '%2$s'.")
    public SearchException invalidIndexPrimaryName(String var1, Pattern var2);

    @Message(id=400595, value="Invalid Elasticsearch index layout: unique key '%1$s' extracted from the index name does not match any of %2$s.")
    public SearchException invalidIndexUniqueKey(String var1, Set<String> var2);

    @Message(id=400596, value="Invalid Elasticsearch index layout: the write alias and read alias are set to the same value: '%1$s'. The write alias and read alias must be different.")
    public SearchException sameWriteAndReadAliases(URLEncodedString var1, @Param EventContext var2);

    @Message(id=400597, value="Missing or imprecise Elasticsearch version: configuration property '%1$s' is set to 'false', so you must set the version explicitly with at least as much precision as 'x.y', where 'x' and 'y' are integers.")
    public SearchException impreciseElasticsearchVersionWhenVersionCheckDisabled(String var1);

    @Message(id=400598, value="The lifecycle strategy cannot be set at the index level anymore. Set the schema management strategy via the property 'hibernate.search.schema_management.strategy' instead.")
    public SearchException lifecycleStrategyMovedToMapper();

    @Message(id=400600, value="Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.")
    public SearchException invalidSortModeAcrossNested(SortMode var1, @Param EventContext var2);

    @Message(id=400601, value="Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.")
    public SearchException invalidSortModeForStringField(SortMode var1, @Param EventContext var2);

    @Message(id=400602, value="Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.")
    public SearchException invalidSortModeForTemporalField(SortMode var1, @Param EventContext var2);

    @Message(id=400603, value="Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.")
    public SearchException invalidSortModeForDistanceSort(SortMode var1, @Param EventContext var2);

    @Message(id=400604, value="Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.")
    public SearchException cannotFilterSortOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=400605, value="Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.")
    public SearchException invalidNestedObjectPathForPredicate(SearchPredicate var1, String var2, List<String> var3);

    @Message(id=400606, value="Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.")
    public SearchException cannotFilterAggregationOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=400607, value="Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.")
    public SearchException indexSchemaFieldTemplateNameConflict(String var1, @Param EventContext var2);

    @Message(id=400608, value="Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.")
    public SearchException invalidFieldValueType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400609, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForIndexing(String var1, @Param EventContext var2);

    @Message(id=400613, value="Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.multi()' when you create the projection.")
    public SearchException invalidSingleValuedProjectionOnMultiValuedField(String var1, @Param EventContext var2);

    @Message(id=400617, value="Implementation class differs: '%1$s' vs. '%2$s'.")
    public SearchException differentImplementationClassForQueryElement(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=400618, value="Field codec differs: '%1$s' vs. '%2$s'.")
    public SearchException differentFieldCodecForQueryElement(Object var1, Object var2);

    @Message(id=400621, value="Invalid dynamic type: '%1$s'. Valid values are: %2$s.")
    public SearchException invalidDynamicType(String var1, List<String> var2);

    @Message(id=400625, value="Unable to update aliases for index '%1$s': %2$s")
    public SearchException elasticsearchAliasUpdateFailed(Object var1, String var2, @Cause Exception var3);

    @Message(id=400626, value="Invalid target hosts configuration: both the 'uris' property and the 'protocol' property are set. Uris: '%1$s'. Protocol: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.")
    public SearchException uriAndProtocol(List<String> var1, String var2);

    @Message(id=400627, value="Invalid target hosts configuration: both the 'uris' property and the 'hosts' property are set. Uris: '%1$s'. Hosts: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.")
    public SearchException uriAndHosts(List<String> var1, List<String> var2);

    @Message(id=400628, value="Invalid target hosts configuration: the 'uris' use different protocols (http, https). All URIs must use the same protocol. Uris: '%1$s'.")
    public SearchException differentProtocolsOnUris(List<String> var1);

    @Message(id=400629, value="Invalid target hosts configuration: the list of hosts must not be empty.")
    public SearchException emptyListOfHosts();

    @Message(id=400630, value="Invalid target hosts configuration: the list of URIs must not be empty.")
    public SearchException emptyListOfUris();

    @Message(id=400631, value="Unable to find the given custom index settings file: '%1$s'.")
    public SearchException customIndexSettingsFileNotFound(String var1, @Param EventContext var2);

    @Message(id=400632, value="Error on loading the given custom index settings file '%1$s': %2$s")
    public SearchException customIndexSettingsErrorOnLoading(String var1, String var2, @Cause Exception var3, @Param EventContext var4);

    @Message(id=400633, value="There are some JSON syntax errors on the given custom index settings file '%1$s': %2$s")
    public SearchException customIndexSettingsJsonSyntaxErrors(String var1, String var2, @Cause Exception var3, @Param EventContext var4);

    @Message(id=400634, value="Invalid use of 'missing().first()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.")
    public SearchException missingFirstOnAscSortNotSupported(@Param EventContext var1);

    @Message(id=400635, value="Invalid use of 'missing().last()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.")
    public SearchException missingLastOnDescSortNotSupported(@Param EventContext var1);

    @Message(id=400636, value="Invalid use of 'missing().use(...)' for a distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.")
    public SearchException missingAsOnSortNotSupported(@Param EventContext var1);

    @Message(id=400637, value="The index schema named predicate '%1$s' was added twice.")
    public SearchException indexSchemaNamedPredicateNameConflict(String var1, @Param EventContext var2);

    @Message(id=400638, value="Predicate definition differs: '%1$s' vs. '%2$s'.")
    public SearchException differentPredicateDefinitionForQueryElement(Object var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400640, value="A search query fetching all hits was requested, but only '%2$s' hits were retrieved because the maximum result window size forces a limit of '%1$s' hits. Refer to Elasticsearch's 'max_result_window_size' setting for more information.")
    public void defaultedLimitedHits(Integer var1, long var2);

    @Message(id=400641, value="Incompatible Elasticsearch version: version '%2$s' does not match version '%1$s' that was provided when the backend was created. You can provide a more precise version on startup, but you cannot override the version that was provided when the backend was created.")
    public SearchException incompatibleElasticsearchVersionOnStart(ElasticsearchVersion var1, ElasticsearchVersion var2);

    @Message(id=400648, value="Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.")
    public SearchException multiTenancyRequiredButExplicitlyDisabledByBackend();

    @Message(id=400649, value="Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.")
    public SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend();

    @Message(id=400650, value="Param with name '%1$s' has not been defined for the named predicate '%2$s'.")
    public SearchException paramNotDefined(String var1, String var2, @Param EventContext var3);

    @Message(id=400651, value="Unable to find the given custom index mapping file: '%1$s'.")
    public SearchException customIndexMappingFileNotFound(String var1, @Param EventContext var2);

    @Message(id=400652, value="Error on loading the given custom index mapping file '%1$s': %2$s")
    public SearchException customIndexMappingErrorOnLoading(String var1, String var2, @Cause Exception var3, @Param EventContext var4);

    @Message(id=400653, value="There are some JSON syntax errors on the given custom index mapping file '%1$s': %2$s")
    public SearchException customIndexMappingJsonSyntaxErrors(String var1, String var2, @Cause Exception var3, @Param EventContext var4);

    @Message(id=400654, value="Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.")
    public SearchException invalidContextForProjectionOnField(String var1, String var2);

    @Message(id=400655, value="Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.multi()' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).multi()'.")
    public SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(String var1, String var2);

    @Message(id=400656, value="Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.")
    public SearchException unexpectedMappedTypeNameForByMappedTypeProjection(String var1, Set<String> var2);

    @Message(id=400657, value="Unable to export the schema for '%1$s' index: %2$s")
    public SearchException unableToExportSchema(String var1, String var2, @Cause IOException var3);

    @Message(id=400658, value="Invalid use of 'missing().lowest()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ")
    public SearchException missingLowestOnAscSortNotSupported(@Param EventContext var1);

    @Message(id=400659, value="Invalid use of 'missing().lowest()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ")
    public SearchException missingLowestOnDescSortNotSupported(@Param EventContext var1);

    @Message(id=400660, value="Invalid highlighter: '%1$s'. You must build the highlighter from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters(SearchHighlighter var1);

    @Message(id=400661, value="Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s, but the given highlighter was built from a scope targeting indexes %2$s.")
    public SearchException queryHighlighterDefinedOnDifferentIndexes(SearchHighlighter var1, Set<String> var2, Set<String> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400662, value="No fields were added to be highlighted, but some query level highlighters were provided. These highlighters will be ignored.")
    public void noFieldsToHighlight();

    @Message(id=400663, value="Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?")
    public SearchException cannotFindHighlighter(String var1, Set<String> var2);

    @Message(id=400664, value="Named highlighters cannot use a blank string as name.")
    public SearchException highlighterNameCannotBeBlank();

    @Message(id=400665, value="Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.")
    public SearchException highlighterWithTheSameNameCannotBeAdded(String var1);

    @Message(id=400666, value="'%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.")
    public SearchException highlighterTypeNotSupported(SearchHighlighterType var1, String var2);

    @Message(id=400667, value="Cannot use 'NO' in combination with other highlightable values. Applied values are: '%1$s'")
    public SearchException unsupportedMixOfHighlightableValues(Set<Highlightable> var1);

    @Message(id=400668, value="The '%1$s' term vector storage strategy is not compatible with the fast vector highlighter. Either change the strategy to one of `WITH_POSITIONS_PAYLOADS`/`WITH_POSITIONS_OFFSETS_PAYLOADS` or remove the requirement for the fast vector highlighter support.")
    public SearchException termVectorDontAllowFastVectorHighlighter(TermVector var1);

    @Message(id=400669, value="Setting the `highlightable` attribute to an empty array is not supported. Set the value to `NO` if the field does not require the highlight projection.")
    public SearchException noHighlightableProvided();

    @Message(id=400670, value="Highlight projection cannot be applied within nested context of '%1$s'.")
    public SearchException cannotHighlightInNestedContext(String var1, @Param EventContext var2);

    @Message(id=400671, value="The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.")
    public SearchException cannotHighlightFieldFromNestedObjectStructure(@Param EventContext var1);

    @Message(id=400672, value="'%1$s' cannot be nested in an object projection. %2$s")
    public SearchException cannotUseProjectionInNestedContext(String var1, String var2, @Param EventContext var3);

    @Message(id=400673, value="The targeted Elasticsearch cluster is reachable, but does not expose its version. Check that the configured Elasticsearch hosts/URI points to the right server. If you are targeting Amazon OpenSearch Serverless, you must set the configuration property '%1$s' explicitly to '%2$s'. See the reference documentation for more information.")
    public SearchException unableToFetchElasticsearchVersion(String var1, ElasticsearchVersion var2);

    @Message(id=400674, value="Cannot check the Elasticsearch version because the targeted Elasticsearch distribution '%s' does not expose its version.")
    public SearchException cannotCheckElasticsearchVersion(ElasticsearchDistributionName var1);

    @Message(id=400675, value="Unexpected Amazon OpenSearch Serverless version: '%1$s'. Amazon OpenSearch Serverless doesn't use version numbers. Set the version to simply '%2$s'.")
    public SearchException unexpectedAwsOpenSearchServerlessVersion(ElasticsearchVersion var1, ElasticsearchVersion var2);

    @Message(id=400676, value="Cannot execute '%s' because Amazon OpenSearch Serverless does not support this operation. Either avoid this operation or switch to another Elasticsearch/OpenSearch distribution.")
    public SearchException cannotExecuteOperationOnAmazonOpenSearchServerless(String var1);

    @Message(id=400677, value="The targeted Elasticsearch cluster does not expose index status, so index status requirements cannot be enforced.")
    public SearchException cannotRequireIndexStatus();

    @Message(id=400678, value="No built-in vector index field type for class: '%1$s'.")
    public SearchException cannotGuessVectorFieldType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Param EventContext var2);

    @Message(id=400679, value="Invalid index field type: missing vector dimension. Define the vector dimension explicitly. %1$s")
    public SearchException nullVectorDimension(String var1, @Param EventContext var2);

    @Message(id=400680, value="Fields of this type cannot be multivalued.")
    public SearchException multiValuedFieldNotAllowed(@Param EventContext var1);

    @Message(id=400681, value="Vector field '%1$s' is defined as a '%2$s' array. Matching against '%3$s' array is unsupported. Use the array of the same type as the vector field.")
    public SearchException vectorKnnMatchVectorTypeDiffersFromField(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=400682, value="Vector field '%1$s' is defined as a vector with '%2$s' dimensions (array length). Matching against an array with length of '%3$s' is unsupported. Use the array of the same size as the vector field.")
    public SearchException vectorKnnMatchVectorDimensionDiffersFromField(String var1, int var2, int var3);

    @Message(id=400685, value="An %1$s distribution version in use is not compatible with the Hibernate Search integration of vector search. Update your %1$s cluster to a %2$s series to get vector search integration enabled.")
    public SearchException searchBackendVersionIncompatibleWithVectorIntegration(String var1, String var2);

    @Message(id=400687, value="An OpenSearch distribution does not allow specifying the `required minimum similarity` option. This option is only applicable to an Elastic distribution of an Elasticsearch backend.")
    public SearchException knnRequiredMinimumSimilarityUnsupportedOption();

    @Message(id=400688, value="The OpenSearch distribution does not allow using %1$s as a space type for a Lucene engine. Try using a different similarity type and refer to the OpenSearch documentation for more details.")
    public SearchException vectorSimilarityNotSupportedByOpenSearchBackend(VectorSimilarity var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400689, value="Using a knn predicate in the nested context when tenant or routing filters are required will lead to unpredictable results and may return fewer documents then expected.")
    public void knnUsedInNestedContextRequiresFilters();
}

