/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.xts.Attribute;
import org.jboss.as.xts.Element;
import org.jboss.as.xts.Namespace;
import org.jboss.as.xts.XTSExtension;
import org.jboss.as.xts.XTSSubsystemDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class XTSSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    XTSSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)PathAddress.pathAddress((PathElement[])new PathElement[]{XTSExtension.SUBSYSTEM_PATH}).toModelNode());
        list.add(subsystem);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        List<Element> expected = this.getExpectedElements(reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!expected.contains((Object)element) || !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case HOST: {
                    this.parseHostElement(reader, subsystem);
                    continue block6;
                }
                case XTS_ENVIRONMENT: {
                    this.parseXTSEnvironmentElement(reader, subsystem);
                    continue block6;
                }
                case DEFAULT_CONTEXT_PROPAGATION: {
                    this.parseDefaultContextPropagationElement(reader, subsystem);
                    continue block6;
                }
                case ASYNC_REGISTRATION: {
                    this.parseAsyncRegistrationElement(reader, subsystem);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (node.hasDefined(XTSSubsystemDefinition.HOST_NAME.getName())) {
            writer.writeStartElement(Element.HOST.getLocalName());
            XTSSubsystemDefinition.HOST_NAME.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (node.hasDefined(XTSSubsystemDefinition.ENVIRONMENT_URL.getName())) {
            writer.writeStartElement(Element.XTS_ENVIRONMENT.getLocalName());
            XTSSubsystemDefinition.ENVIRONMENT_URL.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (node.hasDefined(XTSSubsystemDefinition.DEFAULT_CONTEXT_PROPAGATION.getName())) {
            writer.writeStartElement(Element.DEFAULT_CONTEXT_PROPAGATION.getLocalName());
            XTSSubsystemDefinition.DEFAULT_CONTEXT_PROPAGATION.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (node.hasDefined(XTSSubsystemDefinition.ASYNC_REGISTRATION.getName())) {
            writer.writeStartElement(Element.ASYNC_REGISTRATION.getLocalName());
            XTSSubsystemDefinition.ASYNC_REGISTRATION.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void parseHostElement(XMLExtendedStreamReader reader, ModelNode subsystem) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        this.processAttributes(reader, (index, attribute) -> {
            required.remove(attribute);
            String value = reader.getAttributeValue(index.intValue());
            switch (attribute) {
                case NAME: {
                    XTSSubsystemDefinition.HOST_NAME.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
            }
        });
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void parseXTSEnvironmentElement(XMLExtendedStreamReader reader, ModelNode subsystem) throws XMLStreamException {
        this.processAttributes(reader, (index, attribute) -> {
            String value = reader.getAttributeValue(index.intValue());
            switch (attribute) {
                case URL: {
                    XTSSubsystemDefinition.ENVIRONMENT_URL.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
            }
        });
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseDefaultContextPropagationElement(XMLExtendedStreamReader reader, ModelNode subsystem) throws XMLStreamException {
        this.processAttributes(reader, (index, attribute) -> {
            String value = reader.getAttributeValue(index.intValue());
            switch (attribute) {
                case ENABLED: {
                    if (value == null || !value.toLowerCase(Locale.ENGLISH).equals("true") && !value.toLowerCase(Locale.ENGLISH).equals("false")) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                    }
                    XTSSubsystemDefinition.DEFAULT_CONTEXT_PROPAGATION.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
            }
        });
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseAsyncRegistrationElement(XMLExtendedStreamReader reader, ModelNode subsystem) throws XMLStreamException {
        this.processAttributes(reader, (index, attribute) -> {
            String value = reader.getAttributeValue(index.intValue());
            switch (attribute) {
                case ENABLED: {
                    XTSSubsystemDefinition.ASYNC_REGISTRATION.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
            }
        });
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private List<Element> getExpectedElements(XMLExtendedStreamReader reader) {
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        ArrayList<Element> elements = new ArrayList<Element>();
        if (Namespace.XTS_1_0.equals((Object)namespace)) {
            elements.add(Element.XTS_ENVIRONMENT);
        } else if (Namespace.XTS_2_0.equals((Object)namespace)) {
            elements.add(Element.XTS_ENVIRONMENT);
            elements.add(Element.HOST);
            elements.add(Element.DEFAULT_CONTEXT_PROPAGATION);
        } else if (Namespace.XTS_3_0.equals((Object)namespace)) {
            elements.add(Element.XTS_ENVIRONMENT);
            elements.add(Element.HOST);
            elements.add(Element.DEFAULT_CONTEXT_PROPAGATION);
            elements.add(Element.ASYNC_REGISTRATION);
        }
        return elements;
    }

    private void processAttributes(XMLExtendedStreamReader reader, AttributeProcessor<Integer, Attribute> attributeProcessorCallback) throws XMLStreamException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            attributeProcessorCallback.process(i, attribute);
        }
    }

    @FunctionalInterface
    private static interface AttributeProcessor<T, R> {
        public void process(T var1, R var2) throws XMLStreamException;
    }
}

