/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.invokable;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.invoke.Invoker;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.invokable.ArrayUtils;
import org.jboss.weld.invokable.CleanupActions;
import org.jboss.weld.invokable.LookupUtils;
import org.jboss.weld.invokable.TransformerMetadata;
import org.jboss.weld.invokable.TransformerType;
import org.jboss.weld.invokable.ValueCarryingException;

class MethodHandleUtils {
    static final MethodHandle CLEANUP_ACTIONS_CTOR;
    static final MethodHandle CLEANUP_FOR_VOID;
    static final MethodHandle CLEANUP_FOR_NONVOID;
    static final MethodHandle LOOKUP;
    static final MethodHandle REPLACE_PRIMITIVE_LOOKUP_NULLS;
    static final MethodHandle THROW_VALUE_CARRYING_EXCEPTION;
    static final MethodHandle TRIM_ARRAY_TO_SIZE;

    private MethodHandleUtils() {
    }

    private static MethodHandles.Lookup lookupFor(Executable method) throws IllegalAccessException {
        Class<?> targetClass;
        Module targetModule;
        if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return MethodHandles.publicLookup();
        }
        Module thisModule = MethodHandleUtils.class.getModule();
        if (!thisModule.canRead(targetModule = (targetClass = method.getDeclaringClass()).getModule())) {
            thisModule.addReads(targetModule);
        }
        return MethodHandles.privateLookupIn(targetClass, MethodHandles.lookup());
    }

    static MethodHandle createMethodHandle(Method method) {
        try {
            return MethodHandleUtils.lookupFor(method).unreflect(method);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static MethodHandle createMethodHandle(Constructor<?> constructor) {
        try {
            return MethodHandleUtils.lookupFor(constructor).unreflectConstructor(constructor);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static MethodHandle createMethodHandleFromTransformer(Method targetMethod, TransformerMetadata transformer, Class<?> transformationArgType) {
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (Method m : transformer.getDeclaringClass().getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) && !m.getDeclaringClass().equals(transformer.getDeclaringClass()) || !m.getName().equals(transformer.getMethodName())) continue;
            matchingMethods.add(m);
        }
        if (matchingMethods.isEmpty()) {
            throw new DeploymentException(transformer + ": no method found");
        }
        if (matchingMethods.size() > 1) {
            throw new DeploymentException(transformer + ": more than one method found: " + matchingMethods);
        }
        Method method = (Method)matchingMethods.get(0);
        MethodHandleUtils.validateTransformerMethod(method, transformer, transformationArgType);
        MethodHandle result = MethodHandleUtils.createMethodHandle(method);
        if (transformer.isInputTransformer() && !result.type().returnType().equals(transformationArgType)) {
            result = result.asType(result.type().changeReturnType(transformationArgType));
        } else if (transformer.isOutputTransformer() && result.type().parameterCount() > 0 && !result.type().parameterType(0).equals(transformationArgType)) {
            result = result.asType(result.type().changeParameterType(0, transformationArgType));
        }
        if (TransformerType.EXCEPTION.equals((Object)transformer.getType())) {
            if (targetMethod.getReturnType().isAssignableFrom((Class<?>)result.type().returnType())) {
                result = result.asType(result.type().changeReturnType(targetMethod.getReturnType()));
            } else {
                MethodHandle throwReturnValue = THROW_VALUE_CARRYING_EXCEPTION;
                throwReturnValue = throwReturnValue.asType(throwReturnValue.type().changeReturnType(targetMethod.getReturnType()));
                throwReturnValue = throwReturnValue.asType(throwReturnValue.type().changeParameterType(0, (Class<?>)result.type().returnType()));
                result = MethodHandles.filterReturnValue(result, throwReturnValue);
            }
        }
        return result;
    }

    private static void validateTransformerMethod(Method m, TransformerMetadata transformer, Class<?> transformationArgType) {
        if (!Modifier.isPublic(m.getModifiers())) {
            throw new DeploymentException("All invocation transformers need to be public - " + transformer);
        }
        int paramCount = m.getParameterCount();
        if (transformer.isInputTransformer()) {
            if (!transformationArgType.isAssignableFrom(m.getReturnType())) {
                throw new DeploymentException("Input transformer " + transformer + " has a return value that is not assignable to expected class: " + transformationArgType);
            }
            if (!Modifier.isStatic(m.getModifiers())) {
                if (paramCount != 0) {
                    throw new DeploymentException("Non-static input transformers are expected to have zero input parameters! Transformer: " + transformer);
                }
            } else {
                if (paramCount > 2) {
                    throw new DeploymentException("Static input transformers can only have one or two parameters. " + transformer);
                }
                if (paramCount == 2 && !Consumer.class.equals(m.getParameters()[1].getType())) {
                    throw new DeploymentException("Static input transformers with two parameters can only have Consumer<Runnable> as their second parameter! " + transformer);
                }
            }
        } else if (transformer.isOutputTransformer()) {
            if (!Modifier.isStatic(m.getModifiers())) {
                if (paramCount != 0) {
                    throw new DeploymentException("Non-static output transformers are expected to have zero input parameters! Transformer: " + transformer);
                }
            } else {
                if (paramCount != 1) {
                    throw new DeploymentException("Static output transformers are expected to have one input parameter! Transformer: " + transformer);
                }
                if (!m.getParameters()[0].getType().isAssignableFrom(transformationArgType)) {
                    throw new DeploymentException("Output transformer " + transformer + " parameter is not assignable to the expected type " + transformationArgType);
                }
            }
        } else {
            Class<?>[] params = m.getParameterTypes();
            if (!(params.length == 3 && params[0].equals(transformationArgType) && params[1].equals(Object[].class) && params[2].equals(Invoker.class))) {
                throw new DeploymentException("Invocation wrapper has unexpected parameters " + transformer + "\nExpected param types are: " + transformationArgType + ", Object[], Invoker.class");
            }
        }
    }

    static {
        try {
            CLEANUP_ACTIONS_CTOR = MethodHandleUtils.createMethodHandle(CleanupActions.class.getDeclaredConstructor(new Class[0]));
            String runName = "run";
            CLEANUP_FOR_VOID = MethodHandleUtils.createMethodHandle(CleanupActions.class.getMethod(runName, Throwable.class, CleanupActions.class));
            CLEANUP_FOR_NONVOID = MethodHandleUtils.createMethodHandle(CleanupActions.class.getMethod(runName, Throwable.class, Object.class, CleanupActions.class));
            LOOKUP = MethodHandleUtils.createMethodHandle(LookupUtils.class.getDeclaredMethod("lookup", CleanupActions.class, BeanManager.class, Type.class, Annotation[].class));
            REPLACE_PRIMITIVE_LOOKUP_NULLS = MethodHandleUtils.createMethodHandle(LookupUtils.class.getDeclaredMethod("replacePrimitiveLookupNulls", Object[].class, Class[].class, boolean[].class));
            THROW_VALUE_CARRYING_EXCEPTION = MethodHandleUtils.createMethodHandle(ValueCarryingException.class.getDeclaredMethod("throwReturnValue", Object.class));
            TRIM_ARRAY_TO_SIZE = MethodHandleUtils.createMethodHandle(ArrayUtils.class.getDeclaredMethod("trimArrayToSize", Object[].class, Integer.TYPE));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to locate Weld internal helper method", e);
        }
    }
}

