/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ds.processors;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.util.Enumeration;
import java.util.List;
import org.jboss.as.connector._drivermanager.DriverManagerAdapter;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.DriverService;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.Assert;

public final class DriverProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            ModuleClassLoader classLoader = module.getClassLoader();
            List driverNames = servicesAttachment.getServiceImplementations(Driver.class.getName());
            int idx = 0;
            for (String driverClassName : driverNames) {
                try {
                    boolean driverWrapped;
                    Class<Driver> driverClass = classLoader.loadClass(driverClassName).asSubclass(Driver.class);
                    Constructor<Driver> constructor = driverClass.getConstructor(new Class[0]);
                    Driver driver = constructor.newInstance(new Object[0]);
                    int majorVersion = driver.getMajorVersion();
                    int minorVersion = driver.getMinorVersion();
                    boolean compliant = driver.jdbcCompliant();
                    if (compliant) {
                        ConnectorLogger.DEPLOYER_JDBC_LOGGER.deployingCompliantJdbcDriver(driverClass, majorVersion, minorVersion);
                    } else {
                        ConnectorLogger.DEPLOYER_JDBC_LOGGER.deployingNonCompliantJdbcDriver(driverClass, majorVersion, minorVersion);
                    }
                    String deploymentName = deploymentUnit.getName();
                    Object driverName = deploymentName;
                    boolean bl = driverWrapped = deploymentName.contains(".") && !deploymentName.endsWith(".jar");
                    if (driverWrapped || driverNames.size() != 1) {
                        driverName = (String)driverName + "_" + driverClassName + "_" + majorVersion + "_" + minorVersion;
                    }
                    InstalledDriver driverMetadata = new InstalledDriver((String)driverName, driverClass.getName(), null, null, majorVersion, minorVersion, compliant);
                    DriverService driverService = new DriverService(driverMetadata, driver);
                    phaseContext.getServiceTarget().addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", ((String)driverName).replaceAll("\\.", "_")}), (Service)driverService).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, driverService.getDriverRegistryServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    if (idx == 0 && driverNames.size() != 1 && !driverWrapped) {
                        driverMetadata = new InstalledDriver(deploymentName, driverClass.getName(), null, null, majorVersion, minorVersion, compliant);
                        driverService = new DriverService(driverMetadata, driver);
                        phaseContext.getServiceTarget().addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", deploymentName.replaceAll("\\.", "_")}), (Service)driverService).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, driverService.getDriverRegistryServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    }
                    ++idx;
                }
                catch (Throwable e) {
                    ConnectorLogger.DEPLOYER_JDBC_LOGGER.cannotInstantiateDriverClass(driverClassName, e);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
        List driverNames;
        Module module = (Module)context.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)context.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null && !(driverNames = servicesAttachment.getServiceImplementations(Driver.class.getName())).isEmpty()) {
            try {
                Class driverManagerAdapterClass = module.getClassLoader().loadClass(DriverManagerAdapter.class.getName());
                Method getDriversMethod = driverManagerAdapterClass.getDeclaredMethod("getDrivers", new Class[0]);
                Enumeration drivers = (Enumeration)getDriversMethod.invoke(null, null);
                Method deregisterDriverMethod = driverManagerAdapterClass.getDeclaredMethod("deregisterDriver", Driver.class);
                while (drivers.hasMoreElements()) {
                    Driver driver = (Driver)drivers.nextElement();
                    if (!driverNames.contains(driver.getClass().getName())) continue;
                    deregisterDriverMethod.invoke(null, driver);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Assert.unreachableCode();
            }
        }
    }
}

