/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

final class MetricExporterConfiguration {
    private static final Duration DEFAULT_EXPORT_INTERVAL = Duration.ofMinutes(1L);
    private static final Map<String, String> EXPORTER_ARTIFACT_ID_BY_NAME = new HashMap<String, String>();

    @Nullable
    static MetricReader configureReader(String name, ConfigProperties config, SpiHelper spiHelper, BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer, List<Closeable> closeables) {
        if (name.equals("prometheus")) {
            try {
                Class.forName("io.opentelemetry.exporter.prometheus.PrometheusHttpServer");
                return null;
            }
            catch (ClassNotFoundException unused) {
                throw MetricExporterConfiguration.missingExporterException("prometheus", "opentelemetry-exporter-prometheus");
            }
        }
        NamedSpiManager<MetricExporter> spiExportersManager = MetricExporterConfiguration.metricExporterSpiManager(config, spiHelper);
        MetricExporter metricExporter = MetricExporterConfiguration.configureExporter(name, spiExportersManager);
        closeables.add((Closeable)metricExporter);
        MetricExporter customizedMetricExporter = metricExporterCustomizer.apply((MetricExporter)metricExporter, config);
        if (customizedMetricExporter != metricExporter) {
            closeables.add((Closeable)customizedMetricExporter);
        }
        PeriodicMetricReader reader = PeriodicMetricReader.builder((MetricExporter)customizedMetricExporter).setInterval(config.getDuration("otel.metric.export.interval", DEFAULT_EXPORT_INTERVAL)).build();
        closeables.add((Closeable)reader);
        return reader;
    }

    static NamedSpiManager<MetricExporter> metricExporterSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        return spiHelper.loadConfigurable(ConfigurableMetricExporterProvider.class, ConfigurableMetricExporterProvider::getName, ConfigurableMetricExporterProvider::createExporter, config);
    }

    static MetricExporter configureExporter(String name, NamedSpiManager<MetricExporter> spiExportersManager) {
        MetricExporter metricExporter = spiExportersManager.getByName(name);
        if (metricExporter == null) {
            String artifactId = EXPORTER_ARTIFACT_ID_BY_NAME.get(name);
            if (artifactId != null) {
                throw MetricExporterConfiguration.missingExporterException(name, artifactId);
            }
            throw new ConfigurationException("Unrecognized value for otel.metrics.exporter: " + name);
        }
        return metricExporter;
    }

    private static ConfigurationException missingExporterException(String exporterName, String artifactId) {
        return new ConfigurationException("otel.metrics.exporter set to \"" + exporterName + "\" but " + artifactId + " not found on classpath. Make sure to add it as a dependency.");
    }

    private MetricExporterConfiguration() {
    }

    static {
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging", "opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging-otlp", "opentelemetry-exporter-logging-otlp");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("otlp", "opentelemetry-exporter-otlp");
    }
}

