/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.jboss.as.service.DelegatingSupplier;
import org.jboss.as.service.ReflectionUtils;
import org.jboss.as.service.logging.SarLogger;

final class ValueFactorySupplier
extends DelegatingSupplier {
    private final String methodName;
    private final Class<?>[] paramTypes;
    private final Object[] args;

    ValueFactorySupplier(String methodName, Class<?>[] paramTypes, Object[] args) {
        this.methodName = methodName;
        this.paramTypes = paramTypes;
        this.args = args;
    }

    @Override
    public Object get() {
        Supplier objectSupplier = this.objectSupplier;
        if (objectSupplier == null) {
            throw SarLogger.ROOT_LOGGER.objectSupplierNotAvailable();
        }
        Object o = objectSupplier.get();
        if (o == null) {
            throw SarLogger.ROOT_LOGGER.objectNotAvailable();
        }
        try {
            return ReflectionUtils.getMethod(o.getClass(), this.methodName, this.paramTypes).invoke(o, this.args);
        }
        catch (IllegalAccessException e) {
            throw SarLogger.ROOT_LOGGER.methodIsNotAccessible(e);
        }
        catch (InvocationTargetException e) {
            throw SarLogger.ROOT_LOGGER.failedToInvokeMethod(e);
        }
    }
}

