/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.ejb;

import jakarta.interceptor.InvocationContext;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jboss.weld.Container;
import org.jboss.weld.context.ejb.EjbRequestContext;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.ejb.AbstractEJBRequestScopeActivationInterceptor;

public class SessionBeanInterceptor
extends AbstractEJBRequestScopeActivationInterceptor
implements Serializable {
    private static final long serialVersionUID = 2658712435730329384L;
    private volatile BeanManagerImpl beanManager;
    private volatile transient EjbRequestContext ejbRequestContext;

    @Override
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        if (this.beanManager == null) {
            this.beanManager = this.obtainBeanManager(invocation);
            this.ejbRequestContext = super.getEjbRequestContext();
        }
        return super.aroundInvoke(invocation);
    }

    private BeanManagerImpl obtainBeanManager(InvocationContext invocation) {
        Object value = invocation.getContextData().get("WELD_CONTEXT_ID_KEY");
        String contextId = "STATIC_INSTANCE";
        if (value instanceof String) {
            contextId = (String)value;
        }
        return Container.instance((String)contextId).deploymentManager();
    }

    @Override
    protected EjbRequestContext getEjbRequestContext() {
        return this.ejbRequestContext;
    }

    @Override
    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    private Object readResolve() throws ObjectStreamException {
        return new SessionBeanInterceptor();
    }
}

