/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.impl.massindex.IndexLock;

final class DistributedIndexerLock
implements IndexLock {
    private final String lockName;
    private volatile ClusteredLock clusteredLock;
    private final Cache<?, ?> cache;

    DistributedIndexerLock(Cache<?, ?> cache) {
        this.cache = cache;
        this.lockName = String.format("massIndexer-%s", cache.getName());
    }

    @Override
    public CompletionStage<Boolean> lock() {
        return this.getLock().tryLock();
    }

    @Override
    public CompletionStage<Void> unlock() {
        return this.getLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusteredLock getLock() {
        if (this.clusteredLock == null) {
            DistributedIndexerLock distributedIndexerLock = this;
            synchronized (distributedIndexerLock) {
                if (this.clusteredLock == null) {
                    ClusteredLockManager clusteredLockManager = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)this.cache.getCacheManager());
                    boolean isDefined = clusteredLockManager.isDefined(this.lockName);
                    if (!isDefined) {
                        clusteredLockManager.defineLock(this.lockName);
                    }
                    this.clusteredLock = clusteredLockManager.get(this.lockName);
                }
            }
        }
        return this.clusteredLock;
    }
}

