/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleAggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport V23_INSTANCE = new OracleAggregateSupport(true, JsonSupport.OSON);
    private static final AggregateSupport V21_INSTANCE = new OracleAggregateSupport(false, JsonSupport.OSON);
    private static final AggregateSupport V19_INSTANCE = new OracleAggregateSupport(false, JsonSupport.MERGEPATCH);
    private static final AggregateSupport V18_INSTANCE = new OracleAggregateSupport(false, JsonSupport.QUERY_AND_PATH);
    private static final AggregateSupport V12_INSTANCE = new OracleAggregateSupport(false, JsonSupport.QUERY);
    private static final AggregateSupport LEGACY_INSTANCE = new OracleAggregateSupport(false, JsonSupport.NONE);
    private static final String JSON_QUERY_START = "json_query(";
    private static final String JSON_QUERY_END = "')";
    private final boolean checkConstraintSupport;
    private final JsonSupport jsonSupport;

    private OracleAggregateSupport(boolean checkConstraintSupport, JsonSupport jsonSupport) {
        this.checkConstraintSupport = checkConstraintSupport;
        this.jsonSupport = jsonSupport;
    }

    public static AggregateSupport valueOf(Dialect dialect) {
        DatabaseVersion version = dialect.getVersion();
        switch (version.getMajor()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return V12_INSTANCE;
            }
            case 18: {
                return V18_INSTANCE;
            }
            case 19: 
            case 20: {
                return V19_INSTANCE;
            }
            case 21: 
            case 22: {
                return V21_INSTANCE;
            }
        }
        return version.isSameOrAfter(23) ? V23_INSTANCE : LEGACY_INSTANCE;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String column, ColumnTypeInformation aggregateColumnType, ColumnTypeInformation columnType) {
        switch (aggregateColumnType.getTypeCode()) {
            case 3001: {
                switch (this.jsonSupport) {
                    case OSON: 
                    case MERGEPATCH: 
                    case QUERY_AND_PATH: 
                    case QUERY: {
                        String parentPartExpression = aggregateParentReadExpression.startsWith(JSON_QUERY_START) && aggregateParentReadExpression.endsWith(JSON_QUERY_END) ? aggregateParentReadExpression.substring(JSON_QUERY_START.length(), aggregateParentReadExpression.length() - JSON_QUERY_END.length()) + "." : aggregateParentReadExpression + ",'$.";
                        switch (columnType.getTypeCode()) {
                            case 16: {
                                if (columnType.getTypeName().toLowerCase(Locale.ROOT).trim().startsWith("number")) {
                                    return template.replace(placeholder, "decode(json_value(" + parentPartExpression + column + "'),'true',1,'false',0,null)");
                                }
                            }
                            case -6: 
                            case -5: 
                            case 4: 
                            case 5: {
                                return template.replace(placeholder, "json_value(" + parentPartExpression + column + "' returning " + columnType.getTypeName() + ")");
                            }
                            case 91: {
                                return template.replace(placeholder, "to_date(json_value(" + parentPartExpression + column + "'),'YYYY-MM-DD')");
                            }
                            case 92: {
                                return template.replace(placeholder, "to_timestamp(json_value(" + parentPartExpression + column + "'),'hh24:mi:ss')");
                            }
                            case 93: {
                                return template.replace(placeholder, "to_timestamp(json_value(" + parentPartExpression + column + "'),'YYYY-MM-DD\"T\"hh24:mi:ss.FF9')");
                            }
                            case 2014: 
                            case 3003: {
                                return template.replace(placeholder, "to_timestamp_tz(json_value(" + parentPartExpression + column + "'),'YYYY-MM-DD\"T\"hh24:mi:ss.FF9TZH:TZM')");
                            }
                            case -3: 
                            case -2: 
                            case 4003: {
                                return template.replace(placeholder, "hextoraw(json_value(" + parentPartExpression + column + "'))");
                            }
                            case 2004: 
                            case 2005: 
                            case 2011: {
                                return template.replace(placeholder, "(select * from json_table(" + aggregateParentReadExpression + ",'$' columns (" + column + " " + columnType.getTypeName() + " path '$." + column + "')))");
                            }
                            case 3001: {
                                return template.replace(placeholder, JSON_QUERY_START + parentPartExpression + column + JSON_QUERY_END);
                            }
                        }
                        return template.replace(placeholder, "cast(json_value(" + parentPartExpression + column + "') as " + columnType.getTypeName() + ")");
                    }
                    case NONE: {
                        throw new UnsupportedOperationException("The Oracle version doesn't support JSON aggregates!");
                    }
                }
            }
            case 2002: {
                return template.replace(placeholder, aggregateParentReadExpression + "." + column);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnType.getTypeCode());
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String column, ColumnTypeInformation aggregateColumnType, ColumnTypeInformation columnType) {
        switch (aggregateColumnType.getTypeCode()) {
            case 3001: {
                return aggregateParentAssignmentExpression;
            }
            case 2002: {
                return aggregateParentAssignmentExpression + "." + column;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnType.getTypeCode());
    }

    private String jsonCustomWriteExpression(String customWriteExpression, int sqlTypeCode, String typeName) {
        switch (this.jsonSupport) {
            case OSON: 
            case MERGEPATCH: {
                switch (sqlTypeCode) {
                    case 2005: {
                        return "to_clob(" + customWriteExpression + ")";
                    }
                    case 16: {
                        if (!typeName.toLowerCase(Locale.ROOT).trim().startsWith("number")) break;
                        return "decode(" + customWriteExpression + ",1,'true',0,'false',null)";
                    }
                }
                return customWriteExpression;
            }
        }
        throw new IllegalStateException("JSON not supported!");
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode == 3001;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return this.jsonAggregateColumnWriter(aggregateColumn, columnsToUpdate, typeConfiguration);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    @Override
    public boolean supportsComponentCheckConstraints() {
        return this.checkConstraintSupport;
    }

    private String determineJsonTypeName(SelectableMapping aggregateColumn) {
        String columnDefinition = aggregateColumn.getColumnDefinition();
        if (columnDefinition == null) {
            assert (aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode() == 3001);
            switch (this.jsonSupport) {
                case OSON: {
                    return "json";
                }
                case MERGEPATCH: 
                case QUERY_AND_PATH: 
                case QUERY: {
                    return "blob";
                }
                case NONE: {
                    return "clob";
                }
            }
        }
        return columnDefinition;
    }

    private AggregateSupport.WriteExpressionRenderer jsonAggregateColumnWriter(SelectableMapping aggregateColumn, SelectableMapping[] columns, TypeConfiguration typeConfiguration) {
        return new RootJsonWriteExpression(aggregateColumn, columns, this, typeConfiguration);
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = customWriteExpression.split("\\?");
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("':");
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final boolean nullable;
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns, OracleAggregateSupport aggregateSupport, TypeConfiguration typeConfiguration) {
            super(aggregateColumn, aggregateSupport);
            this.nullable = aggregateColumn.isNullable();
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(columns, aggregateSupport, typeConfiguration);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            sqlAppender.append("json_mergepatch(");
            if (this.nullable) {
                sqlAppender.append("coalesce(");
                sqlAppender.append((CharSequence)basePath);
                sqlAppender.append(",json_object(returning ");
                sqlAppender.append(this.ddlTypeName);
                sqlAppender.append("))");
            } else {
                sqlAppender.append((CharSequence)basePath);
            }
            sqlAppender.append(',');
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
            sqlAppender.append(" returning ");
            sqlAppender.append(this.ddlTypeName);
            sqlAppender.append(')');
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();
        protected final EmbeddableMappingType embeddableMappingType;
        protected final String ddlTypeName;

        public AggregateJsonWriteExpression(SelectableMapping selectableMapping, OracleAggregateSupport aggregateSupport) {
            this.embeddableMappingType = ((AggregateJdbcType)selectableMapping.getJdbcMapping().getJdbcType()).getEmbeddableMappingType();
            this.ddlTypeName = aggregateSupport.determineJsonTypeName(selectableMapping);
        }

        protected void initializeSubExpressions(SelectableMapping[] columns, OracleAggregateSupport aggregateSupport, TypeConfiguration typeConfiguration) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                EmbeddableMappingType currentMappingType = this.embeddableMappingType;
                for (int i = 1; i < parts.length - 1; ++i) {
                    SelectableMapping selectableMapping = currentMappingType.getJdbcValueSelectable(currentMappingType.getSelectableIndex(parts[i].getSelectableName()));
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression(selectableMapping, aggregateSupport));
                    currentMappingType = currentAggregate.embeddableMappingType;
                }
                int sqlTypeCode = column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, aggregateSupport.jsonCustomWriteExpression(customWriteExpression, sqlTypeCode, AggregateJsonWriteExpression.determineTypeName(column, typeConfiguration))));
            }
        }

        private static String determineTypeName(SelectableMapping column, TypeConfiguration typeConfiguration) {
            if (column.getColumnDefinition() == null) {
                DdlType ddlType = typeConfiguration.getDdlTypeRegistry().getDescriptor(column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode());
                return ddlType.getCastTypeName(column.getJdbcMapping().getJdbcType(), column.getJdbcMapping().getJavaTypeDescriptor(), column.getLength(), column.getPrecision(), column.getScale());
            }
            String typeName = column.getColumnDefinition();
            return typeName;
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("json_object");
            int separator = 40;
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                JsonWriteExpression value = entry.getValue();
                String subPath = path + "->'" + column + "'";
                sb.append((char)separator);
                if (value instanceof AggregateJsonWriteExpression) {
                    sb.append('\'');
                    sb.append(column);
                    sb.append("':");
                    value.append(sb, subPath, translator, expression);
                } else {
                    value.append(sb, subPath, translator, expression);
                }
                separator = 44;
            }
            sb.append(" returning ");
            sb.append(this.ddlTypeName);
            sb.append(')');
        }
    }

    static interface JsonWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }

    static enum JsonSupport {
        OSON,
        MERGEPATCH,
        QUERY_AND_PATH,
        QUERY,
        NONE;

    }
}

