/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation.internal;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;

public class FederationQueueEntry {
    private final FederationConsumerInfo consumerInfo;
    private final Set<String> consumerDemand = new HashSet<String>();
    private FederationConsumerInternal consumer;

    public FederationQueueEntry(FederationConsumerInfo consumerInfo) {
        this.consumerInfo = consumerInfo;
    }

    public String getQueueName() {
        return this.consumerInfo.getQueueName();
    }

    public FederationConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public boolean hasConsumer() {
        return this.consumer != null;
    }

    public FederationConsumerInternal getConsumer() {
        return this.consumer;
    }

    public FederationQueueEntry setConsumer(FederationConsumerInternal consumer) {
        Objects.requireNonNull(consumer, "Cannot assign a null consumer to this entry, call clear to unset");
        this.consumer = consumer;
        return this;
    }

    public FederationQueueEntry clearConsumer() {
        this.consumer = null;
        return this;
    }

    public boolean hasDemand() {
        return !this.consumerDemand.isEmpty();
    }

    public FederationQueueEntry addDemand(ServerConsumer consumer) {
        this.consumerDemand.add(FederationQueueEntry.identifyConsumer(consumer));
        return this;
    }

    public FederationQueueEntry removeDemand(ServerConsumer consumer) {
        this.consumerDemand.remove(FederationQueueEntry.identifyConsumer(consumer));
        return this;
    }

    private static String identifyConsumer(ServerConsumer consumer) {
        return consumer.getConnectionID().toString() + ":" + consumer.getSessionID() + ":" + consumer.getID();
    }
}

