/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.spi.core.remoting.ConnectorFactory;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public class ConnectorServiceDefinition
extends PersistentResourceDefinition {
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.FACTORY_CLASS, CommonAttributes.PARAMS};

    ConnectorServiceDefinition() {
        super(MessagingExtension.CONNECTOR_SERVICE_PATH, MessagingExtension.getResourceDescriptionResolver(false, "connector-service"), (OperationStepHandler)new ConnectorServiceAddHandler(ATTRIBUTES), (OperationStepHandler)new ActiveMQReloadRequiredHandlers.RemoveStepHandler());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        ConnectorServiceWriteAttributeHandler writeHandler = new ConnectorServiceWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }

    private static void checkFactoryClass(String factoryClass) throws OperationFailedException {
        try {
            ClassloadingUtil.newInstanceFromClassLoader((String)factoryClass, ConnectorFactory.class);
        }
        catch (Throwable t) {
            throw MessagingLogger.ROOT_LOGGER.unableToLoadConnectorServiceFactoryClass(factoryClass);
        }
    }

    static class ConnectorServiceAddHandler
    extends ActiveMQReloadRequiredHandlers.AddStepHandler {
        ConnectorServiceAddHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        @Override
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String factoryClass = CommonAttributes.FACTORY_CLASS.resolveModelAttribute(context, model).asString();
            ConnectorServiceDefinition.checkFactoryClass(factoryClass);
            super.performRuntime(context, operation, model);
        }
    }

    static class ConnectorServiceWriteAttributeHandler
    extends ReloadRequiredWriteAttributeHandler {
        ConnectorServiceWriteAttributeHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandback) throws OperationFailedException {
            if (CommonAttributes.FACTORY_CLASS.getName().equals(attributeName)) {
                ConnectorServiceDefinition.checkFactoryClass(resolvedValue.asString());
            }
            return super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, voidHandback);
        }
    }
}

