/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ExternalJMSTopicDefinition;
import org.wildfly.extension.messaging.activemq.jms.ExternalJMSTopicService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

public class ExternalJMSTopicAdd
extends AbstractAddStepHandler {
    public static final ExternalJMSTopicAdd INSTANCE = new ExternalJMSTopicAdd();

    private ExternalJMSTopicAdd() {
        super(ExternalJMSTopicDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName jmsTopicServiceName = JMSServices.getJmsTopicBaseServiceName(MessagingServices.getActiveMQServiceName((String)null)).append(new String[]{name});
        boolean enabledAMQ1Prefix = ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX.resolveModelAttribute(context, model).asBoolean();
        ExternalJMSTopicService jmsTopicService = ExternalJMSTopicService.installService(name, jmsTopicServiceName, serviceTarget, enabledAMQ1Prefix);
        for (String entry : CommonAttributes.DESTINATION_ENTRIES.unwrap((ExpressionResolver)context, model)) {
            MessagingLogger.ROOT_LOGGER.boundJndiName(entry);
            BinderServiceUtil.installBinderService(serviceTarget, entry, jmsTopicService, jmsTopicServiceName);
        }
    }
}

