/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.bridge.inbound;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import java.io.IOException;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.star.logging.RESTATLogger;
import org.jboss.logging.Logger;

public class InboundBridgeOrphanFilter
implements XAResourceOrphanFilter {
    private static final Logger LOG = Logger.getLogger(InboundBridgeOrphanFilter.class);

    public XAResourceOrphanFilter.Vote checkXid(Xid xid) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeOrphanFilter.checkXid(" + String.valueOf(xid) + ")"));
        }
        XAResourceOrphanFilter.Vote vote = XAResourceOrphanFilter.Vote.ROLLBACK;
        if (xid.getFormatId() != 131081) {
            vote = XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        if (this.isInStore(xid)) {
            vote = XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeOrphanFilter.checkXid: " + vote.name()));
        }
        return vote;
    }

    private boolean isInStore(Xid xid) {
        RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
        InputObjectState states = new InputObjectState();
        try {
            if (recoveryStore.allObjUids(SubordinateAtomicAction.getType(), states) && states.notempty()) {
                boolean finished = false;
                do {
                    Uid uid;
                    if ((uid = UidHelper.unpackFrom((InputBuffer)states)).notEquals(Uid.nullUid())) {
                        SubordinateAtomicAction saa = new SubordinateAtomicAction(uid, true);
                        if (!saa.getXid().equals(xid)) continue;
                        return true;
                    }
                    finished = true;
                } while (!finished);
            }
        }
        catch (ObjectStoreException e) {
            RESTATLogger.atI18NLogger.warn_loadInStoreInboundBridgeOrphanFilter((Throwable)e);
        }
        catch (IOException e) {
            RESTATLogger.atI18NLogger.warn_isInStoreInboundBridgeOrphanFilter((Throwable)e);
        }
        return false;
    }
}

