/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneIntegerDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneByteFieldCodec
extends AbstractLuceneNumericFieldCodec<Byte, Integer> {
    public LuceneByteFieldCodec(Indexing indexing, DocValues docValues, Storage storage, Byte indexNullAsValue) {
        super(indexing, docValues, storage, indexNullAsValue);
    }

    @Override
    void addStoredToDocument(LuceneDocumentContent documentBuilder, String absoluteFieldPath, Byte value, Integer encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.intValue()));
    }

    @Override
    public Byte decode(IndexableField field) {
        Integer integer = (Integer)field.numericValue();
        return integer.byteValue();
    }

    @Override
    public Integer encode(Byte value) {
        return (int)value;
    }

    @Override
    public Byte decode(Integer encoded) {
        return encoded.byteValue();
    }

    @Override
    public LuceneNumericDomain<Integer> getDomain() {
        return LuceneIntegerDomain.get();
    }
}

