/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.dto;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.activemq.artemis.utils.XmlProvider;

public class XmlUtil {
    public static <T> T decode(Class<T> clazz, File configuration) throws Exception {
        return XmlUtil.decode(clazz, configuration, null, null, null);
    }

    public static <T> T decode(Class<T> clazz, File configuration, String artemisHome, String artemisInstance, URI artemisURIInstance) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.apache.activemq.artemis.dto");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        InputStream xsdStream = XmlUtil.class.getClassLoader().getResourceAsStream("org.apache.activemq/dto/activemq.xsd");
        StreamSource xsdSource = new StreamSource(xsdStream);
        Schema schema = XmlProvider.newSchema((Source)xsdSource, Collections.singletonMap("http://apache.org/xml/features/validation/schema-full-checking", false));
        unmarshaller.setSchema(schema);
        Properties props = new Properties(System.getProperties());
        if (artemisHome != null) {
            props.put("artemis.home", artemisHome);
        }
        if (artemisInstance != null) {
            props.put("artemis.instance", artemisInstance);
        }
        if (artemisURIInstance != null) {
            props.put("artemis.URI.instance", artemisURIInstance.toString());
        }
        XMLStreamReader reader = XmlProvider.createXMLStreamReader((InputStream)new FileInputStream(configuration));
        reader = new PropertiesFilter(reader, props);
        return clazz.cast(unmarshaller.unmarshal(reader));
    }

    static class PropertiesFilter
    extends StreamReaderDelegate {
        static final Pattern pattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
        private final Properties props;

        PropertiesFilter(XMLStreamReader parent, Properties props) {
            super(parent);
            this.props = props;
        }

        @Override
        public String getAttributeValue(int index) {
            return this.filter(super.getAttributeValue(index));
        }

        public String filter(String str) {
            Matcher matcher;
            int start = 0;
            while ((matcher = pattern.matcher(str)).find(start)) {
                String group = matcher.group(1);
                String property = this.props.getProperty(group);
                if (property != null) {
                    str = matcher.replaceFirst(Matcher.quoteReplacement(property));
                    continue;
                }
                start = matcher.end();
            }
            return str;
        }
    }
}

