/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.AbstractMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.ComparatorMarshaller;

public class SortedMapMarshaller<T extends SortedMap<Object, Object>>
extends AbstractMapMarshaller<T> {
    private static final int COMPARATOR_INDEX = 3;
    private final Function<Comparator<? super Object>, T> factory;

    public SortedMapMarshaller(Function<Comparator<? super Object>, T> factory) {
        super(((SortedMap)factory.apply((Comparator<? super Object>)ComparatorMarshaller.INSTANCE.createInitialValue())).getClass());
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader<Object> comparatorReader = reader.createFieldSetReader(ComparatorMarshaller.INSTANCE, 3);
        Object comparator = ComparatorMarshaller.INSTANCE.createInitialValue();
        SortedMap map = (SortedMap)this.factory.apply((Comparator<? super Object>)comparator);
        LinkedList<Object> keys = new LinkedList<Object>();
        LinkedList<Object> values = new LinkedList<Object>();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index == 1) {
                keys.add(reader.readAny());
                continue;
            }
            if (index == 2) {
                values.add(reader.readAny());
                continue;
            }
            if (comparatorReader.contains(index)) {
                comparator = (Comparator)comparatorReader.readField(comparator);
                map = (SortedMap)this.factory.apply((Comparator<? super Object>)comparator);
                continue;
            }
            reader.skipField(tag);
        }
        Iterator keyIterator = keys.iterator();
        Iterator valueIterator = values.iterator();
        while (keyIterator.hasNext() || valueIterator.hasNext()) {
            map.put(keyIterator.next(), valueIterator.next());
        }
        return (T)map;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T map) throws IOException {
        super.writeTo(writer, map);
        Comparator comparator = map.comparator();
        if (comparator != ComparatorMarshaller.INSTANCE.createInitialValue()) {
            writer.createFieldSetWriter(ComparatorMarshaller.INSTANCE, 3).writeFields(comparator);
        }
    }
}

