/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.URIAffinity;

public abstract class Affinity
implements Serializable {
    private static final long serialVersionUID = -2985180758368879373L;
    public static final Affinity NONE = new NoAffinity();
    public static final Affinity LOCAL = new LocalAffinity();
    public static final String WEAK_AFFINITY_CONTEXT_KEY = "jboss.ejb.weak.affinity";

    Affinity() {
    }

    public static Affinity forUri(URI uri) {
        if (uri == null || !uri.isAbsolute()) {
            return NONE;
        }
        String scheme = uri.getScheme();
        assert (scheme != null);
        switch (scheme) {
            case "node": {
                return new NodeAffinity(uri.getSchemeSpecificPart());
            }
            case "cluster": {
                return new ClusterAffinity(uri.getSchemeSpecificPart());
            }
            case "local": {
                return LOCAL;
            }
        }
        return new URIAffinity(uri);
    }

    public abstract URI getUri();

    public boolean equals(Object other) {
        return other instanceof Affinity && this.equals((Affinity)other);
    }

    public abstract boolean equals(Affinity var1);

    public abstract int hashCode();

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (!(this instanceof URIAffinity || this instanceof NodeAffinity || this instanceof ClusterAffinity || this instanceof LocalAffinity || this instanceof NoAffinity)) {
            throw new InvalidClassException(this.getClass().getName(), "Disallowed affinity class");
        }
    }

    static class LocalAffinity
    extends Affinity {
        private static final long serialVersionUID = -2052559528672779420L;
        private static final URI uri;

        LocalAffinity() {
        }

        @Override
        public int hashCode() {
            return -1;
        }

        @Override
        public URI getUri() {
            return uri;
        }

        @Override
        public boolean equals(Object other) {
            return other == this;
        }

        @Override
        public boolean equals(Affinity obj) {
            return obj == this;
        }

        protected Object readResolve() {
            return LOCAL;
        }

        public String toString() {
            return "Local";
        }

        static {
            try {
                uri = new URI("local", "-", null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class NoAffinity
    extends Affinity {
        private static final long serialVersionUID = -2052559528672779420L;

        NoAffinity() {
        }

        @Override
        public int hashCode() {
            return -1;
        }

        @Override
        public URI getUri() {
            return null;
        }

        @Override
        public boolean equals(Object other) {
            return other == this;
        }

        @Override
        public boolean equals(Affinity obj) {
            return obj == this;
        }

        protected Object readResolve() {
            return NONE;
        }

        public String toString() {
            return "None";
        }
    }
}

