/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsarj.handler;

import com.arjuna.webservices.logging.WSCLogger;
import com.arjuna.webservices.wsarj.ArjunaConstants;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.ProtocolException;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;

public class InstanceIdentifierHandler
implements SOAPHandler<SOAPMessageContext> {
    private static Set<QName> headers = Collections.singleton(ArjunaConstants.WSARJ_ELEMENT_INSTANCE_IDENTIFIER_QNAME);

    public Set<QName> getHeaders() {
        return headers;
    }

    public boolean handleMessage(SOAPMessageContext context) throws ProtocolException {
        boolean outbound = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
        if (outbound) {
            return this.handleMessageOutbound(context);
        }
        return this.handlemessageInbound(context);
    }

    protected boolean handleMessageOutbound(SOAPMessageContext context) throws ProtocolException {
        try {
            ArjunaContext arjunaContext = ArjunaContext.getCurrentContext((MessageContext)context);
            if (arjunaContext != null) {
                InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
                SOAPMessage soapMessage = context.getMessage();
                SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
                SOAPHeader soapHeader = soapEnvelope.getHeader();
                if (soapHeader == null) {
                    soapHeader = soapEnvelope.addHeader();
                }
                SOAPHeaderElement headerElement = soapHeader.addHeaderElement(ArjunaConstants.WSARJ_ELEMENT_INSTANCE_IDENTIFIER_QNAME);
                headerElement.setValue(instanceIdentifier.getInstanceIdentifier());
                headerElement.setMustUnderstand(true);
            }
        }
        catch (Exception se) {
            throw new ProtocolException((Throwable)se);
        }
        if (WSCLogger.logger.isTraceEnabled()) {
            WSCLogger.logger.trace((Object)"InstanceIdentifierHandler.handleMessageOutbound()");
            WSCLogger.traceMessage(context);
        }
        return true;
    }

    private boolean handlemessageInbound(SOAPMessageContext context) throws ProtocolException {
        try {
            SOAPMessage soapMessage = context.getMessage();
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            Iterator iterator = soapEnvelope.getHeader().examineAllHeaderElements();
            while (iterator.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)iterator.next();
                if (!ArjunaConstants.WSARJ_ELEMENT_INSTANCE_IDENTIFIER_QNAME.equals(headerElement.getElementQName())) continue;
                headerElement.setMustUnderstand(false);
                String identifierString = headerElement.getValue();
                if (identifierString == null) continue;
                ArjunaContext arjunaContext = ArjunaContext.getContext((MessageContext)context);
                arjunaContext.setInstanceIdentifier(new InstanceIdentifier(identifierString));
                break;
            }
        }
        catch (Exception se) {
            throw new ProtocolException((Throwable)se);
        }
        if (WSCLogger.logger.isTraceEnabled()) {
            WSCLogger.logger.trace((Object)"InstanceIdentifierHandler.handlemessageInbound()");
            WSCLogger.traceMessage(context);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

