/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jdbc.batch.internal.BatchBuilderImpl;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class BatchBuilderInitiator
implements StandardServiceInitiator<BatchBuilder> {
    public static final BatchBuilderInitiator INSTANCE = new BatchBuilderInitiator();

    @Override
    public Class<BatchBuilder> getServiceInitiated() {
        return BatchBuilder.class;
    }

    @Override
    public BatchBuilder initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        Object builder = configurationValues.get("hibernate.jdbc.batch.builder");
        if (builder == null) {
            builder = configurationValues.get("hibernate.jdbc.factory_class");
        }
        if (builder == null) {
            return new BatchBuilderImpl(ConfigurationHelper.getInt("hibernate.jdbc.batch_size", configurationValues, 1));
        }
        if (builder instanceof BatchBuilder) {
            return (BatchBuilder)builder;
        }
        String builderClassName = builder.toString();
        try {
            return (BatchBuilder)registry.getService(ClassLoaderService.class).classForName(builderClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceException("Could not build explicit BatchBuilder [" + builderClassName + "]", e);
        }
    }
}

