/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import org.wildfly.clustering.ejb.cache.timer.TimerIndex;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerIndexKey;
import org.wildfly.clustering.marshalling.spi.DelimitedFormatter;

public class InfinispanTimerIndexKeyFormatter
extends DelimitedFormatter<InfinispanTimerIndexKey> {
    public InfinispanTimerIndexKeyFormatter() {
        super(InfinispanTimerIndexKey.class, "#", InfinispanTimerIndexKeyFormatter::fromStrings, InfinispanTimerIndexKeyFormatter::toStrings);
    }

    static InfinispanTimerIndexKey fromStrings(String[] values) {
        String className = values[0];
        String methodName = values[1];
        int parameters = values.length == 3 ? 0 : 1;
        int index = Integer.parseInt(values[values.length - 1]);
        return new InfinispanTimerIndexKey(new TimerIndex(className, methodName, parameters, index));
    }

    static String[] toStrings(InfinispanTimerIndexKey key) {
        String[] stringArray;
        TimerIndex index = (TimerIndex)key.getId();
        int parameters = index.getParameters();
        String indexValue = Integer.toString(index.getIndex());
        if (parameters == 0) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = index.getDeclaringClassName();
            stringArray2[1] = index.getMethodName();
            stringArray = stringArray2;
            stringArray2[2] = indexValue;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = index.getDeclaringClassName();
            stringArray3[1] = index.getMethodName();
            stringArray3[2] = "";
            stringArray = stringArray3;
            stringArray3[3] = indexValue;
        }
        return stringArray;
    }
}

