/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import jakarta.persistence.TupleElement;
import java.lang.reflect.Constructor;
import java.util.List;
import org.hibernate.InstantiationException;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.RowTransformer;

public class RowTransformerConstructorImpl<T>
implements RowTransformer<T> {
    private final Class<T> type;
    private final TupleMetadata tupleMetadata;
    private final Constructor<T> constructor;

    public RowTransformerConstructorImpl(Class<T> type, TupleMetadata tupleMetadata) {
        this.type = type;
        this.tupleMetadata = tupleMetadata;
        List<TupleElement<?>> elements = tupleMetadata.getList();
        Class[] sig = new Class[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            sig[i] = elements.get(i).getJavaType();
        }
        try {
            this.constructor = type.getDeclaredConstructor(sig);
            this.constructor.setAccessible(true);
        }
        catch (Exception e) {
            throw new InstantiationException("Cannot instantiate query result type ", type, e);
        }
    }

    @Override
    public T transformRow(Object[] row) {
        try {
            return this.constructor.newInstance(row);
        }
        catch (Exception e) {
            throw new InstantiationException("Cannot instantiate query result type", this.type, e);
        }
    }

    @Override
    public int determineNumberOfResultElements(int rawElementCount) {
        return 1;
    }
}

