/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.registry.MutableCommandRegistry;
import org.aesh.io.Resource;

@CommandDefinition(name="add-command", description="specify a groovy command file ")
public class GroovyCommand
implements Command<CommandInvocation> {
    private CommandInvocation commandInvocation;
    private MutableCommandRegistry commandRegistry;
    @Arguments
    private List<Resource> files;

    public GroovyCommand(MutableCommandRegistry mutableCommandRegistry) {
        this.commandRegistry = mutableCommandRegistry;
    }

    @Override
    public CommandResult execute(CommandInvocation commandInvocation) {
        this.commandInvocation = commandInvocation;
        if (this.files != null && this.files.size() > 0 && this.files.get(0).isLeaf()) {
            Resource f = this.files.get(0).resolve(commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory()).get(0);
            this.loadCommand(f);
        }
        return CommandResult.SUCCESS;
    }

    private void loadCommand(Resource file) {
        try {
            ClassLoader parent = this.getClass().getClassLoader();
            GroovyClassLoader loader = new GroovyClassLoader(parent);
            Class groovyClass = loader.parseClass(file.read(), file.getName());
            if (groovyClass.isAnnotationPresent(CommandDefinition.class)) {
                boolean correctClass = false;
                for (Class<?> groovyInterface : groovyClass.getInterfaces()) {
                    if (!groovyInterface.equals(Command.class)) continue;
                    correctClass = true;
                }
                if (correctClass) {
                    this.commandRegistry.addCommand(groovyClass);
                    this.commandInvocation.getShell().writeln("Added " + groovyClass.getName() + " to commands");
                } else {
                    this.commandInvocation.getShell().writeln("Groovy command do not implement Command interface");
                }
            } else {
                this.commandInvocation.getShell().writeln("Groovy command do not contain CommandDefinition annotation");
            }
        }
        catch (IOException | CommandRegistryException e) {
            e.printStackTrace();
        }
    }
}

