/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.sso;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;

public class CompositeSSO<A, D, S, L>
implements SSO<A, D, S, L> {
    private final String id;
    private final A authentication;
    private final Sessions<D, S> sessions;
    private final AtomicReference<L> localContext;
    private final Supplier<L> localContextFactory;
    private final Remover<String> remover;

    public CompositeSSO(String id, A authentication, Sessions<D, S> sessions, AtomicReference<L> localContext, Supplier<L> localContextFactory, Remover<String> remover) {
        this.id = id;
        this.authentication = authentication;
        this.sessions = sessions;
        this.localContext = localContext;
        this.localContextFactory = localContextFactory;
        this.remover = remover;
    }

    public String getId() {
        return this.id;
    }

    public A getAuthentication() {
        return this.authentication;
    }

    public Sessions<D, S> getSessions() {
        return this.sessions;
    }

    public void invalidate() {
        this.remover.remove((Object)this.id);
    }

    public L getLocalContext() {
        if (this.localContextFactory == null) {
            return null;
        }
        L localContext = this.localContext.get();
        if (localContext == null && !this.localContext.compareAndSet(null, localContext = this.localContextFactory.get())) {
            return this.localContext.get();
        }
        return localContext;
    }
}

