/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.io.File;
import java.nio.file.Path;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.messaging.activemq.PathDefinition;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public abstract class AbstractArtemisActionHandler
extends AbstractRuntimeOnlyHandler {
    protected String resolvePath(OperationContext context, PathElement pathElement) throws OperationFailedException {
        Resource serverResource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = serverResource.hasChild(pathElement) ? serverResource.getChild(pathElement).getModel() : new ModelNode();
        String path = PathDefinition.PATHS.get(pathElement.getValue()).resolveModelAttribute(context, model).asString();
        String relativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model).asString();
        String relativeTo = AbsolutePathService.isAbsoluteUnixOrWindowsPath((String)path) ? null : relativeToPath;
        return this.getPathManager(context).resolveRelativePathEntry(path, relativeTo);
    }

    protected Path getServerTempDir(OperationContext context) {
        return new File(this.getPathManager(context).getPathEntry("jboss.controller.temp.dir").resolvePath()).toPath();
    }

    protected File resolveFile(OperationContext context, PathElement pathElement) throws OperationFailedException {
        return new File(this.resolvePath(context, pathElement));
    }

    protected void checkAllowedOnJournal(OperationContext context, String operationName) throws OperationFailedException {
        ModelNode journalDatasource = ServerDefinition.JOURNAL_DATASOURCE.resolveModelAttribute(context, context.readResource(PathAddress.EMPTY_ADDRESS).getModel());
        if (journalDatasource.isDefined() && journalDatasource.asString() != null && !"".equals(journalDatasource.asString())) {
            throw MessagingLogger.ROOT_LOGGER.operationNotAllowedOnJdbcStore(operationName);
        }
    }

    private PathManager getPathManager(OperationContext context) {
        ServiceController service = context.getServiceRegistry(false).getService(context.getCapabilityServiceName(PathManager.SERVICE_DESCRIPTOR));
        return (PathManager)service.getService().getValue();
    }
}

