/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.wildfly;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.projectodd.vdx.wildfly.SchemaProvider;

public class WildFlySchemaProvider
implements SchemaProvider {
    @Override
    public List<URL> schemas() {
        File schemaRoot = this.schemaRoot();
        if (schemaRoot != null) {
            File[] schemaFiles = schemaRoot.listFiles();
            if (schemaRoot.exists() && schemaFiles != null) {
                return Arrays.stream(schemaFiles).filter(f -> f.getName().endsWith(".xsd")).map(f -> {
                    try {
                        return f.toURI().toURL();
                    }
                    catch (MalformedURLException ex) {
                        throw new RuntimeException(ex);
                    }
                }).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String schemaResource() {
        File schemaRoot = this.schemaRoot();
        return schemaRoot != null ? schemaRoot.getAbsolutePath() : null;
    }

    private File schemaRoot() {
        String jbossHome = System.getProperty("jboss.home.dir");
        return jbossHome != null ? new File(jbossHome, "docs/schema") : null;
    }
}

