/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.ZoneOffset;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.AbstractConvertingDefaultBridge;

public final class DefaultZoneOffsetBridge
extends AbstractConvertingDefaultBridge<ZoneOffset, Integer> {
    public static final DefaultZoneOffsetBridge INSTANCE = new DefaultZoneOffsetBridge();

    private DefaultZoneOffsetBridge() {
    }

    @Override
    protected String toString(ZoneOffset value) {
        return value.getId();
    }

    @Override
    protected ZoneOffset fromString(String value) {
        return ParseUtils.parseZoneOffset((String)value);
    }

    @Override
    protected Integer toConvertedValue(ZoneOffset value) {
        return value.getTotalSeconds();
    }

    @Override
    protected ZoneOffset fromConvertedValue(Integer value) {
        return ZoneOffset.ofTotalSeconds(value);
    }
}

