/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.WindowedCount;

class ConsumerCoordinatorMetrics {
    final Sensor commitSensor;
    final Sensor revokeCallbackSensor;
    final Sensor assignCallbackSensor;
    final Sensor loseCallbackSensor;

    ConsumerCoordinatorMetrics(SubscriptionState subscriptions, Metrics metrics, String metricGrpPrefix) {
        String metricGrpName = metricGrpPrefix + "-coordinator-metrics";
        this.commitSensor = metrics.sensor("commit-latency");
        this.commitSensor.add(metrics.metricName("commit-latency-avg", metricGrpName, "The average time taken for a commit request"), new Avg());
        this.commitSensor.add(metrics.metricName("commit-latency-max", metricGrpName, "The max time taken for a commit request"), new Max());
        this.commitSensor.add(new Meter(new WindowedCount(), metrics.metricName("commit-rate", metricGrpName, "The number of commit calls per second"), metrics.metricName("commit-total", metricGrpName, "The total number of commit calls")));
        this.revokeCallbackSensor = metrics.sensor("partition-revoked-latency");
        this.revokeCallbackSensor.add(metrics.metricName("partition-revoked-latency-avg", metricGrpName, "The average time taken for a partition-revoked rebalance listener callback"), new Avg());
        this.revokeCallbackSensor.add(metrics.metricName("partition-revoked-latency-max", metricGrpName, "The max time taken for a partition-revoked rebalance listener callback"), new Max());
        this.assignCallbackSensor = metrics.sensor("partition-assigned-latency");
        this.assignCallbackSensor.add(metrics.metricName("partition-assigned-latency-avg", metricGrpName, "The average time taken for a partition-assigned rebalance listener callback"), new Avg());
        this.assignCallbackSensor.add(metrics.metricName("partition-assigned-latency-max", metricGrpName, "The max time taken for a partition-assigned rebalance listener callback"), new Max());
        this.loseCallbackSensor = metrics.sensor("partition-lost-latency");
        this.loseCallbackSensor.add(metrics.metricName("partition-lost-latency-avg", metricGrpName, "The average time taken for a partition-lost rebalance listener callback"), new Avg());
        this.loseCallbackSensor.add(metrics.metricName("partition-lost-latency-max", metricGrpName, "The max time taken for a partition-lost rebalance listener callback"), new Max());
        Measurable numParts = (config, now) -> subscriptions.numAssignedPartitions();
        metrics.addMetric(metrics.metricName("assigned-partitions", metricGrpName, "The number of partitions currently assigned to this consumer"), numParts);
    }
}

