/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.singleton.server.SingletonLogger;

public class SingletonLogger_$logger
extends DelegatingBasicLogger
implements SingletonLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SingletonLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public SingletonLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void startSingleton(String service) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startSingleton$str(), (Object)service);
    }

    protected String startSingleton$str() {
        return "WFLYCLSN0001: This node will now operate as the singleton provider of the %s service";
    }

    @Override
    public final void stopSingleton(String service) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stopSingleton$str(), (Object)service);
    }

    protected String stopSingleton$str() {
        return "WFLYCLSN0002: This node will no longer operate as the singleton provider of the %s service";
    }

    @Override
    public final void elected(String node, String service) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.elected$str(), (Object)node, (Object)service);
    }

    protected String elected$str() {
        return "WFLYCLSN0003: %s elected as the singleton provider of the %s service";
    }

    protected String noResponseFromPrimary$str() {
        return "WFLYCLSN0004: No response received from primary provider of the %s service, retrying...";
    }

    @Override
    public final IllegalStateException noResponseFromPrimary(String service) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noResponseFromPrimary$str(), service));
        SingletonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void serviceStartFailed(StartException e, String service) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.serviceStartFailed$str(), (Object)service);
    }

    protected String serviceStartFailed$str() {
        return "WFLYCLSN0005: Failed to start %s service";
    }

    @Override
    public final void quorumNotReached(String service, int quorum) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.quorumNotReached$str(), (Object)service, (Object)quorum);
    }

    protected String quorumNotReached$str() {
        return "WFLYCLSN0006: Failed to reach quorum of %2$d for %1$s service. No primary singleton provider will be elected.";
    }

    @Override
    public final void quorumJustReached(String service, int quorum) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.quorumJustReached$str(), (Object)service, (Object)quorum);
    }

    protected String quorumJustReached$str() {
        return "WFLYCLSN0007: Just reached required quorum of %2$d for %1$s service. If this cluster loses another member, no node will be chosen to provide this service.";
    }

    protected String multiplePrimaryProvidersDetected$str() {
        return "WFLYCLSN0008: Detected multiple primary providers for %s service: %s";
    }

    @Override
    public final IllegalArgumentException multiplePrimaryProvidersDetected(String serviceName, Collection<GroupMember> providers) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.multiplePrimaryProvidersDetected$str(), serviceName, providers));
        SingletonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notStarted$str() {
        return "WFLYCLSN0009: Singleton service %s is not started.";
    }

    @Override
    public final IllegalStateException notStarted(String serviceName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notStarted$str(), serviceName));
        SingletonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noPrimaryElected(String service) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noPrimaryElected$str(), (Object)service);
    }

    protected String noPrimaryElected$str() {
        return "WFLYCLSN0010: No node was elected as the singleton provider of the %s service";
    }

    protected String invalidQuorum$str() {
        return "WFLYCLSN0011: Specified quorum %d must be greater than zero";
    }

    @Override
    public final IllegalArgumentException invalidQuorum(int quorum) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidQuorum$str(), quorum));
        SingletonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

