/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.smallrye.opentelemetry.implementation.exporters.OtlpExporterUtil;
import io.smallrye.opentelemetry.implementation.exporters.sender.VertxGrpcSender;
import io.smallrye.opentelemetry.implementation.exporters.sender.VertxHttpSender;
import io.vertx.core.Vertx;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;

public abstract class AbstractVertxExporterProvider<T extends Marshaler> {
    private static final String OTEL_EXPORTER_OTLP_PROTOCOL = "otel.exporter.otlp.protocol";
    private static final String OTEL_EXPORTER_OTLP_SIGNAL_PROTOCOL = "otel.exporter.otlp.%s.protocol";
    private static final String OTEL_EXPORTER_OTLP_TIMEOUT = "otel.exporter.otlp.timeout";
    private static final String OTEL_EXPORTER_OTLP_SIGNAL_TIMEOUT = "otel.exporter.otlp.%s.timeout";
    private static final String OTEL_EXPORTER_OTLP_SIGNAL_ENDPOINT = "otel.exporter.otlp.%s.endpoint";
    private static final String OTEL_EXPORTER_OTLP_COMPRESSION = "otel.exporter.otlp.compression";
    private static final String OTEL_EXPORTER_OTLP_SIGNAL_COMPRESSION = "otel.exporter.otlp.%s.compression";
    private static final String MIMETYPE_PROTOBUF = "application/x-protobuf";
    private final String signalType;
    private final String exporterName;

    public AbstractVertxExporterProvider(String signalType, String exporterName) {
        this.signalType = signalType;
        this.exporterName = exporterName;
    }

    public String getName() {
        return this.exporterName;
    }

    protected String getSignalType() {
        return this.signalType;
    }

    protected GrpcExporter<T> createGrpcExporter(ConfigProperties config, String grpcEndpointPath) throws URISyntaxException {
        return new GrpcExporter(this.getName(), this.getSignalType(), this.createGrpcSender(config, grpcEndpointPath), MeterProvider::noop);
    }

    protected HttpExporter<T> createHttpExporter(ConfigProperties config, String httpEndpointPath) throws URISyntaxException {
        return new HttpExporter(this.getName(), this.getSignalType(), (HttpSender)this.createHttpSender(config, httpEndpointPath), MeterProvider::noop, false);
    }

    protected VertxGrpcSender<T> createGrpcSender(ConfigProperties config, String grpcEndpointPath) throws URISyntaxException {
        return new VertxGrpcSender(new URI(this.getOtlpEndpoint(config, "http://localhost:4317")), grpcEndpointPath, this.getCompression(config), this.getTimeout(config), OtlpExporterUtil.populateTracingExportHttpHeaders(), Vertx.vertx());
    }

    protected VertxHttpSender createHttpSender(ConfigProperties config, String httpEndpointPath) throws URISyntaxException {
        return new VertxHttpSender(new URI(this.getOtlpEndpoint(config, "http://localhost:4318")), httpEndpointPath, this.getCompression(config), this.getTimeout(config), OtlpExporterUtil.populateTracingExportHttpHeaders(), MIMETYPE_PROTOBUF, Vertx.vertx());
    }

    protected IllegalArgumentException buildUnsupportedProtocolException(String protocol) {
        String signalProperty = String.format(OTEL_EXPORTER_OTLP_SIGNAL_ENDPOINT, this.signalType);
        return new IllegalArgumentException(String.format("Unsupported OTLP protocol %s specified. ", protocol) + String.format("Please check the `%s` and/or '%s' properties", signalProperty, "otel.exporter.otlp.endpoint"));
    }

    protected String getConfig(ConfigProperties config, String defaultValue, String ... keys) {
        String key;
        String value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && (value = config.getString(key = stringArray[i])) == null; ++i) {
        }
        return value != null ? value : defaultValue;
    }

    protected String getProtocol(ConfigProperties config) {
        String signalKey = this.signalType.replace("span", "traces");
        return this.getConfig(config, "grpc", String.format(OTEL_EXPORTER_OTLP_SIGNAL_PROTOCOL, signalKey), OTEL_EXPORTER_OTLP_PROTOCOL);
    }

    protected boolean getCompression(ConfigProperties config) {
        return Boolean.parseBoolean(this.getConfig(config, "true", String.format(OTEL_EXPORTER_OTLP_SIGNAL_COMPRESSION, this.signalType), OTEL_EXPORTER_OTLP_COMPRESSION));
    }

    protected Duration getTimeout(ConfigProperties config) {
        return Duration.ofSeconds(Integer.parseInt(this.getConfig(config, "10", String.format(OTEL_EXPORTER_OTLP_SIGNAL_TIMEOUT, this.signalType), OTEL_EXPORTER_OTLP_TIMEOUT)));
    }

    protected String getOtlpEndpoint(ConfigProperties config, String defaultEndpoint) {
        return this.getConfig(config, defaultEndpoint, String.format(OTEL_EXPORTER_OTLP_SIGNAL_ENDPOINT, this.signalType), "otel.exporter.otlp.endpoint");
    }
}

