/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.manager.DefaultCacheContainer;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.wildfly.subsystem.service.capture.ServiceValueRegistry;

public class CacheContainerServiceConfigurator
implements ResourceServiceConfigurator {
    private final RuntimeCapability<Void> capability;
    private final ServiceValueRegistry<Cache<?, ?>> registry;

    public CacheContainerServiceConfigurator(RuntimeCapability<Void> capability, ServiceValueRegistry<Cache<?, ?>> registry) {
        this.capability = capability;
        this.registry = registry;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        List aliases = CacheContainerResourceDefinition.ListAttribute.ALIASES.resolveModelAttribute((ExpressionResolver)context, model).asListOrEmpty();
        final ServiceDependency configuration = ServiceDependency.on((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER_CONFIGURATION, (String)name);
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        final CacheLifecycleListener listener = new CacheLifecycleListener(this.registry, (CacheContainerResource)context.readResource(PathAddress.EMPTY_ADDRESS));
        Supplier<EmbeddedCacheManager> factory = new Supplier<EmbeddedCacheManager>(){

            @Override
            public EmbeddedCacheManager get() {
                GlobalConfiguration global = (GlobalConfiguration)configuration.get();
                String defaultCacheName = global.defaultCacheName().orElse(null);
                ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder(global.classLoader(), new GlobalConfigurationBuilder().read(global));
                if (defaultCacheName != null) {
                    holder.newConfigurationBuilder(defaultCacheName);
                }
                DefaultCacheManager manager = new DefaultCacheManager(holder, false);
                if (defaultCacheName != null) {
                    manager.undefineConfiguration(defaultCacheName);
                }
                return manager;
            }
        };
        UnaryOperator<EmbeddedCacheManager> wrapper = new UnaryOperator<EmbeddedCacheManager>(){

            @Override
            public EmbeddedCacheManager apply(EmbeddedCacheManager manager) {
                return new DefaultCacheContainer(manager, (ModuleLoader)loader.get());
            }
        };
        Consumer<EmbeddedCacheManager> start = new Consumer<EmbeddedCacheManager>(){

            @Override
            public void accept(EmbeddedCacheManager manager) {
                manager.start();
                manager.addListener(listener);
                InfinispanLogger.ROOT_LOGGER.infof("Started %s cache container", name);
            }
        };
        Consumer<EmbeddedCacheManager> stop = new Consumer<EmbeddedCacheManager>(){

            @Override
            public void accept(EmbeddedCacheManager manager) {
                manager.removeListener(listener);
                manager.stop();
                InfinispanLogger.ROOT_LOGGER.infof("Stopped %s cache container", name);
            }
        };
        CapabilityServiceInstaller.Builder builder = CapabilityServiceInstaller.builder(this.capability, (Function)wrapper, (Supplier)factory);
        for (ModelNode alias : aliases) {
            builder.provides(context.getCapabilityServiceSupport().getCapabilityServiceName(InfinispanServiceDescriptor.CACHE_CONTAINER, alias.asString()));
        }
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)builder.blocking()).requires(List.of(configuration, loader))).onStart((Consumer)start)).onStop((Consumer)stop)).asPassive()).build();
    }

    @Listener
    static class CacheLifecycleListener {
        private final ServiceValueRegistry<Cache<?, ?>> registry;
        private final Registrar<String> registrar;
        private final Map<String, Registration> registrations = new ConcurrentHashMap<String, Registration>();

        CacheLifecycleListener(ServiceValueRegistry<Cache<?, ?>> registry, Registrar<String> registrar) {
            this.registry = registry;
            this.registrar = registrar;
        }

        @CacheStarted
        public CompletionStage<Void> cacheStarted(CacheStartedEvent event) {
            String containerName = event.getCacheManager().getCacheManagerConfiguration().cacheManagerName();
            String cacheName = event.getCacheName();
            InfinispanLogger.ROOT_LOGGER.cacheStarted(cacheName, containerName);
            this.registrations.put(cacheName, this.registrar.register((Object)cacheName));
            Consumer captor = this.registry.add((Object)ServiceDependency.on((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE, (String)containerName, (String)cacheName));
            EmbeddedCacheManager container = event.getCacheManager();
            BlockingManager blocking = (BlockingManager)container.getGlobalComponentRegistry().getComponent(BlockingManager.class);
            blocking.asExecutor(event.getCacheName()).execute(() -> captor.accept(container.getCache(cacheName)));
            return CompletableFuture.completedStage(null);
        }

        @CacheStopped
        public CompletionStage<Void> cacheStopped(CacheStoppedEvent event) {
            String containerName = event.getCacheManager().getCacheManagerConfiguration().cacheManagerName();
            String cacheName = event.getCacheName();
            this.registry.remove((Object)ServiceDependency.on((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE, (String)containerName, (String)cacheName));
            try (Registration registration = this.registrations.remove(cacheName);){
                InfinispanLogger.ROOT_LOGGER.cacheStopped(cacheName, containerName);
            }
            return CompletableFuture.completedStage(null);
        }
    }
}

