/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.tag;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.smallrye.openapi.api.models.tags.TagImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsReader;
import io.smallrye.openapi.runtime.io.tag.TagConstant;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class TagReader {
    private TagReader() {
    }

    public static Optional<List<Tag>> readTags(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue != null) {
            IoLogging.logger.annotationsArray("@Tag");
            AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (AnnotationInstance tagAnno : nestedArray) {
                if (JandexUtil.isRef(tagAnno)) continue;
                tags.add(TagReader.readTag(context, tagAnno));
            }
            return Optional.of(tags);
        }
        return Optional.empty();
    }

    public static Optional<List<Tag>> readTags(JsonNode node) {
        if (node != null && node.isArray()) {
            IoLogging.logger.jsonArray("Tag");
            ArrayNode nodes = (ArrayNode)node;
            ArrayList<Tag> rval = new ArrayList<Tag>(nodes.size());
            for (JsonNode tagNode : nodes) {
                rval.add(TagReader.readTag(tagNode));
            }
            return Optional.of(rval);
        }
        return Optional.empty();
    }

    public static Tag readTag(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        Objects.requireNonNull(annotationInstance, "Tag annotation must not be null");
        IoLogging.logger.singleAnnotation("@Tag");
        TagImpl tag = new TagImpl();
        tag.setName((String)context.annotations().value(annotationInstance, "name"));
        tag.setDescription((String)context.annotations().value(annotationInstance, "description"));
        tag.setExternalDocs(ExternalDocsReader.readExternalDocs(context, annotationInstance.value("externalDocs")));
        tag.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
        return tag;
    }

    private static Tag readTag(JsonNode node) {
        IoLogging.logger.singleJsonNode("Tag");
        TagImpl tag = new TagImpl();
        tag.setName(JsonUtil.stringProperty(node, "name"));
        tag.setDescription(JsonUtil.stringProperty(node, "description"));
        tag.setExternalDocs(ExternalDocsReader.readExternalDocs(node.get("externalDocs")));
        ExtensionReader.readExtensions(node, tag);
        return tag;
    }

    public static boolean hasTagAnnotation(AnnotationScannerContext context, AnnotationTarget target) {
        return context.annotations().hasAnnotation(target, TagConstant.DOTNAME_TAG, TagConstant.DOTNAME_TAGS);
    }

    public static List<AnnotationInstance> getTagAnnotations(AnnotationScannerContext context, AnnotationTarget target) {
        return context.annotations().getRepeatableAnnotation(target, TagConstant.DOTNAME_TAG, TagConstant.DOTNAME_TAGS);
    }
}

