/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.DefineConfigurationAction;
import org.infinispan.security.actions.GetCacheAction;
import org.infinispan.security.actions.GetCacheConfigurationFromManagerAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static void defineConfiguration(EmbeddedCacheManager cacheManager, String cacheName, Configuration configurationOverride) {
        SecurityActions.doPrivileged(new DefineConfigurationAction(cacheManager, cacheName, configurationOverride));
    }

    static void getCache(EmbeddedCacheManager cacheManager, String cacheName) {
        SecurityActions.doPrivileged(new GetCacheAction(cacheManager, cacheName));
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return SecurityActions.doPrivileged(new GetGlobalComponentRegistryAction(cacheManager));
    }

    static Configuration getCacheConfiguration(EmbeddedCacheManager cacheManager, String name) {
        return SecurityActions.doPrivileged(new GetCacheConfigurationFromManagerAction(cacheManager, name));
    }

    static void stopCache(Cache<?, ?> cache) {
        SecurityActions.doPrivileged(() -> {
            cache.stop();
            return null;
        });
    }
}

