/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;

public final class ExplanationValues
implements Values<Explanation> {
    private final IndexSearcher indexSearcher;
    private final Query luceneQuery;
    private int currentLeafDocBase;

    public ExplanationValues(TopDocsDataCollectorExecutionContext context) {
        this.indexSearcher = context.getIndexSearcher();
        this.luceneQuery = context.executedQuery();
    }

    @Override
    public void context(LeafReaderContext context) throws IOException {
        this.currentLeafDocBase = context.docBase;
    }

    @Override
    public Explanation get(int doc) throws IOException {
        return this.indexSearcher.explain(this.luceneQuery, this.currentLeafDocBase + doc);
    }
}

