/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public final class LRAConstants {
    public static final String COORDINATOR_PATH_NAME = "lra-coordinator";
    public static final String RECOVERY_COORDINATOR_PATH_NAME = "recovery";
    public static final String COMPLETE = "complete";
    public static final String COMPENSATE = "compensate";
    public static final String STATUS = "status";
    public static final String LEAVE = "leave";
    public static final String AFTER = "after";
    public static final String FORGET = "forget";
    public static final String STATUS_PARAM_NAME = "Status";
    public static final String CLIENT_ID_PARAM_NAME = "ClientID";
    public static final String TIMELIMIT_PARAM_NAME = "TimeLimit";
    public static final String PARENT_LRA_PARAM_NAME = "ParentLRA";
    public static final String QUERY_PAIR_SEPARATOR = "&";
    public static final String QUERY_FIELD_SEPARATOR = "=";
    public static final String RECOVERY_PARAM = "recoveryCount";
    public static final String HTTP_METHOD_NAME = "method";
    public static final String API_VERSION_1_0 = "1.0";
    public static final String API_VERSION_1_1 = "1.1";
    public static final String[] NARAYANA_LRA_API_SUPPORTED_VERSIONS = new String[]{"1.0", "1.1"};
    public static final String CURRENT_API_VERSION_STRING = "1.1";
    public static final String NARAYANA_LRA_API_VERSION_HEADER_NAME = "Narayana-LRA-API-version";
    public static final String NARAYANA_LRA_PARTICIPANT_DATA_HEADER_NAME = "Narayana-LRA-Participant-Data";
    public static final String NARAYANA_LRA_PARTICIPANT_LINK_HEADER_NAME = "Narayana-LRA-Participant-Link";
    public static final long PARTICIPANT_TIMEOUT = 2L;
    public static final String ALLOW_PARTICIPANT_DATA = "lra.participant.data";
    private static final Pattern UID_REGEXP_EXTRACT_MATCHER = Pattern.compile(".*/([^/?]+).*");

    private LRAConstants() {
    }

    public static String getLRAUid(String lraId) {
        return lraId == null ? null : UID_REGEXP_EXTRACT_MATCHER.matcher(lraId).replaceFirst("$1");
    }

    public static String getLRAUid(URI lraId) {
        if (lraId == null) {
            return null;
        }
        String path = lraId.getPath();
        if (path == null) {
            return null;
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static URI getLRACoordinatorUrl(URI lraId) {
        if (lraId == null) {
            return null;
        }
        String lraIdPath = lraId.getPath();
        String lraCoordinatorPath = lraIdPath.substring(0, lraIdPath.lastIndexOf(COORDINATOR_PATH_NAME)) + COORDINATOR_PATH_NAME;
        try {
            return new URI(lraId.getScheme(), lraId.getUserInfo(), lraId.getHost(), lraId.getPort(), lraCoordinatorPath, null, null);
        }
        catch (URISyntaxException use) {
            throw new IllegalStateException("Cannot construct URI from the LRA coordinator URL path '" + lraCoordinatorPath + "' extracted from the LRA id URI '" + String.valueOf(lraId) + "'");
        }
    }
}

