/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.http.HttpEntity;
import org.hibernate.search.backend.elasticsearch.ElasticsearchDistributionName;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.client.impl.GsonHttpEntity;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClient;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchClientUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<String> DISTRIBUTION_ACCESSOR = JsonAccessor.root().property("version").property("distribution").asString();
    private static final JsonAccessor<String> VERSION_ACCESSOR = JsonAccessor.root().property("version").property("number").asString();

    private ElasticsearchClientUtils() {
    }

    public static boolean isSuccessCode(int code) {
        return 200 <= code && code < 300;
    }

    public static HttpEntity toEntity(Gson gson, ElasticsearchRequest request) throws IOException {
        List<JsonObject> bodyParts = request.bodyParts();
        if (bodyParts.isEmpty()) {
            return null;
        }
        return new GsonHttpEntity(gson, bodyParts);
    }

    public static ElasticsearchVersion tryGetElasticsearchVersion(ElasticsearchClient client) {
        ElasticsearchRequest request = ElasticsearchRequest.get().build();
        ElasticsearchResponse response = null;
        try {
            response = (ElasticsearchResponse)Futures.unwrappedExceptionJoin(client.submit(request));
            if (response.statusCode() == 404) {
                return null;
            }
            if (!ElasticsearchClientUtils.isSuccessCode(response.statusCode())) {
                throw log.elasticsearchResponseIndicatesFailure();
            }
            ElasticsearchDistributionName distributionOptional = DISTRIBUTION_ACCESSOR.get(response.body()).map(ElasticsearchDistributionName::fromServerResponseRepresentation).orElse(ElasticsearchDistributionName.ELASTIC);
            String version = VERSION_ACCESSOR.get(response.body()).orElseThrow(() -> new AssertionFailure("Missing version number in JSON response"));
            return ElasticsearchVersion.of(distributionOptional, version);
        }
        catch (RuntimeException e) {
            throw log.elasticsearchRequestFailed(request, response, e.getMessage(), e);
        }
    }
}

